/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBasicBuilderParameters {
    private BasicBuilderParameters params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new BasicBuilderParameters();
    }

    @Test
    void testCloneDefaultLookups() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        Set<Lookup> looks = Collections.singleton(look);
        this.params.setDefaultLookups(looks);
        BasicBuilderParameters clone = this.params.clone();
        Collection defLooks = (Collection)this.params.getParameters().get("defaultLookups");
        defLooks.clear();
        defLooks = (Collection)clone.getParameters().get("defaultLookups");
        Assertions.assertEquals((int)1, (int)defLooks.size());
        Assertions.assertTrue((boolean)defLooks.contains(look));
    }

    @Test
    void testClonePrefixLookups() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        Map<String, Lookup> lookups = Collections.singletonMap("test", look);
        this.params.setPrefixLookups(lookups);
        BasicBuilderParameters clone = this.params.clone();
        Map map = (Map)this.params.getParameters().get("prefixLookups");
        map.clear();
        map = (Map)clone.getParameters().get("prefixLookups");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertSame((Object)look, map.get("test"));
    }

    @Test
    void testCloneValues() {
        ConfigurationLogger log = (ConfigurationLogger)Mockito.mock(ConfigurationLogger.class);
        ConfigurationInterpolator ci = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        ListDelimiterHandler handler1 = (ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class);
        ListDelimiterHandler handler2 = (ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class);
        this.params.setListDelimiterHandler(handler1);
        this.params.setLogger(log);
        this.params.setInterpolator(ci);
        this.params.setThrowExceptionOnMissing(true);
        BasicBuilderParameters clone = this.params.clone();
        this.params.setListDelimiterHandler(handler2);
        this.params.setThrowExceptionOnMissing(false);
        Map map = clone.getParameters();
        Assertions.assertSame((Object)log, map.get("logger"));
        Assertions.assertSame((Object)ci, map.get("interpolator"));
        Assertions.assertEquals((Object)handler1, map.get("listDelimiterHandler"));
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    void testDefaults() {
        Map paramMap = this.params.getParameters();
        Assertions.assertTrue((boolean)paramMap.isEmpty());
    }

    @Test
    void testFetchBeanHelperNoSet() {
        Assertions.assertNull((Object)BasicBuilderParameters.fetchBeanHelper((Map)this.params.getParameters()));
    }

    @Test
    void testFetchBeanHelperNullMap() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BasicBuilderParameters.fetchBeanHelper(null));
    }

    @Test
    void testFetchInterpolatorSpecification() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        Lookup l1 = (Lookup)Mockito.mock(Lookup.class);
        Lookup l2 = (Lookup)Mockito.mock(Lookup.class);
        Lookup l3 = (Lookup)Mockito.mock(Lookup.class);
        HashMap<String, Lookup> prefixLookups = new HashMap<String, Lookup>();
        prefixLookups.put("p1", l1);
        prefixLookups.put("p2", l2);
        Set<Lookup> defLookups = Collections.singleton(l3);
        this.params.setParentInterpolator(parent);
        this.params.setPrefixLookups(prefixLookups);
        this.params.setDefaultLookups(defLookups);
        Map map = this.params.getParameters();
        InterpolatorSpecification spec = BasicBuilderParameters.fetchInterpolatorSpecification((Map)map);
        Assertions.assertSame((Object)parent, (Object)spec.getParentInterpolator());
        Assertions.assertEquals(prefixLookups, (Object)spec.getPrefixLookups());
        Assertions.assertEquals((int)1, (int)spec.getDefaultLookups().size());
        Assertions.assertTrue((boolean)spec.getDefaultLookups().contains(l3));
    }

    @Test
    void testFetchInterpolatorSpecificationEmpty() {
        InterpolatorSpecification spec = BasicBuilderParameters.fetchInterpolatorSpecification((Map)this.params.getParameters());
        Assertions.assertNull((Object)spec.getInterpolator());
        Assertions.assertTrue((boolean)spec.getDefaultLookups().isEmpty());
    }

    @Test
    void testFetchInterpolatorSpecificationInvalidCollectionValue() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("defaultLookups", Collections.singleton("not a lookup"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> BasicBuilderParameters.fetchInterpolatorSpecification((Map)map));
    }

    @Test
    void testFetchInterpolatorSpecificationInvalidDataType() {
        HashMap<String, TestBasicBuilderParameters> map = new HashMap<String, TestBasicBuilderParameters>();
        map.put("interpolator", this);
        Assertions.assertThrows(IllegalArgumentException.class, () -> BasicBuilderParameters.fetchInterpolatorSpecification((Map)map));
    }

    @Test
    void testFetchInterpolatorSpecificationInvalidMapKey() {
        HashMap map = new HashMap();
        HashMap<Integer, Object> prefix = new HashMap<Integer, Object>();
        prefix.put(42, Mockito.mock(Lookup.class));
        map.put("prefixLookups", prefix);
        Assertions.assertThrows(IllegalArgumentException.class, () -> BasicBuilderParameters.fetchInterpolatorSpecification((Map)map));
    }

    @Test
    void testFetchInterpolatorSpecificationInvalidMapValue() {
        HashMap map = new HashMap();
        HashMap<String, TestBasicBuilderParameters> prefix = new HashMap<String, TestBasicBuilderParameters>();
        prefix.put("test", this);
        map.put("prefixLookups", prefix);
        Assertions.assertThrows(IllegalArgumentException.class, () -> BasicBuilderParameters.fetchInterpolatorSpecification((Map)map));
    }

    @Test
    void testFetchInterpolatorSpecificationNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BasicBuilderParameters.fetchInterpolatorSpecification(null));
    }

    @Test
    void testFetchInterpolatorSpecificationWithInterpolator() {
        ConfigurationInterpolator ci = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        this.params.setInterpolator(ci);
        InterpolatorSpecification spec = BasicBuilderParameters.fetchInterpolatorSpecification((Map)this.params.getParameters());
        Assertions.assertSame((Object)ci, (Object)spec.getInterpolator());
        Assertions.assertNull((Object)spec.getParentInterpolator());
    }

    @Test
    void testGetParametersDefensiveCopy() {
        Map map1 = this.params.getParameters();
        HashMap mapCopy = new HashMap(map1);
        map1.put("otherProperty", "value");
        Map map2 = this.params.getParameters();
        Assertions.assertNotSame((Object)map1, (Object)map2);
        Assertions.assertEquals(mapCopy, (Object)map2);
    }

    @Test
    void testInheritFrom() {
        BeanHelper beanHelper = new BeanHelper();
        ConfigurationDecoder decoder = (ConfigurationDecoder)Mockito.mock(ConfigurationDecoder.class);
        DefaultConversionHandler conversionHandler = new DefaultConversionHandler();
        DefaultListDelimiterHandler listDelimiterHandler = new DefaultListDelimiterHandler('#');
        ConfigurationLogger logger = new ConfigurationLogger("test");
        ReadWriteSynchronizer synchronizer = new ReadWriteSynchronizer();
        this.params.setBeanHelper(beanHelper).setConfigurationDecoder(decoder).setConversionHandler((ConversionHandler)conversionHandler).setListDelimiterHandler((ListDelimiterHandler)listDelimiterHandler).setLogger(logger).setSynchronizer((Synchronizer)synchronizer).setThrowExceptionOnMissing(true);
        BasicBuilderParameters p2 = new BasicBuilderParameters();
        p2.inheritFrom(this.params.getParameters());
        Map parameters = p2.getParameters();
        Assertions.assertEquals((Object)beanHelper, parameters.get("config-BeanHelper"));
        Assertions.assertEquals((Object)decoder, parameters.get("configurationDecoder"));
        Assertions.assertEquals((Object)conversionHandler, parameters.get("conversionHandler"));
        Assertions.assertEquals((Object)listDelimiterHandler, parameters.get("listDelimiterHandler"));
        Assertions.assertEquals((Object)logger, parameters.get("logger"));
        Assertions.assertEquals((Object)synchronizer, parameters.get("synchronizer"));
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
    }

    @Test
    void testInheritFromNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.params.inheritFrom(null));
    }

    @Test
    void testInheritFromUndefinedProperties() {
        BasicBuilderParameters p2 = new BasicBuilderParameters().setThrowExceptionOnMissing(true);
        p2.inheritFrom(Collections.emptyMap());
        Map parameters = p2.getParameters();
        Assertions.assertEquals(Collections.singletonMap("throwExceptionOnMissing", Boolean.TRUE), (Object)parameters);
    }

    @Test
    void testMerge() {
        ListDelimiterHandler handler1 = (ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class);
        ListDelimiterHandler handler2 = (ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("throwExceptionOnMissing", Boolean.TRUE);
        props.put("listDelimiterHandler", handler1);
        props.put("other", "test");
        props.put("config-test", "reserved");
        BuilderParameters p = (BuilderParameters)Mockito.mock(BuilderParameters.class);
        Mockito.when((Object)p.getParameters()).thenReturn(props);
        this.params.setListDelimiterHandler(handler2);
        this.params.merge(p);
        Map map = this.params.getParameters();
        Assertions.assertEquals((Object)handler2, map.get("listDelimiterHandler"));
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
        Assertions.assertEquals((Object)"test", map.get("other"));
        Assertions.assertFalse((boolean)map.containsKey("config-test"));
        ((BuilderParameters)Mockito.verify((Object)p)).getParameters();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{p});
    }

    @Test
    void testMergeNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.params.merge(null));
    }

    @Test
    void testSetBeanHelper() {
        BeanHelper helper = new BeanHelper();
        Assertions.assertSame((Object)this.params, (Object)this.params.setBeanHelper(helper));
        Assertions.assertSame((Object)helper, (Object)BasicBuilderParameters.fetchBeanHelper((Map)this.params.getParameters()));
    }

    @Test
    void testSetConfigurationDecoder() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)Mockito.mock(ConfigurationDecoder.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setConfigurationDecoder(decoder));
        Assertions.assertSame((Object)decoder, this.params.getParameters().get("configurationDecoder"));
    }

    @Test
    void testSetConversionHandler() {
        ConversionHandler handler = (ConversionHandler)Mockito.mock(ConversionHandler.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setConversionHandler(handler));
        Assertions.assertSame((Object)handler, this.params.getParameters().get("conversionHandler"));
    }

    @Test
    void testSetDefaultLookups() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        Set<Lookup> looks = Collections.singleton(look);
        Assertions.assertSame((Object)this.params, (Object)this.params.setDefaultLookups(looks));
        Collection col = (Collection)this.params.getParameters().get("defaultLookups");
        Assertions.assertNotSame((Object)col, looks);
        Assertions.assertEquals((int)1, (int)col.size());
        Assertions.assertSame((Object)look, col.iterator().next());
        Collection col2 = (Collection)this.params.getParameters().get("defaultLookups");
        Assertions.assertNotSame((Object)col, (Object)col2);
    }

    @Test
    void testSetDefaultLookupsNull() {
        this.params.setDefaultLookups(new ArrayList());
        this.params.setDefaultLookups(null);
        Assertions.assertFalse((boolean)this.params.getParameters().containsKey("defaultLookups"));
    }

    @Test
    void testSetInterpolator() {
        ConfigurationInterpolator ci = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setInterpolator(ci));
        Assertions.assertSame((Object)ci, this.params.getParameters().get("interpolator"));
    }

    @Test
    void testSetListDelimiter() {
        ListDelimiterHandler handler = (ListDelimiterHandler)Mockito.mock(ListDelimiterHandler.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setListDelimiterHandler(handler));
        Assertions.assertSame((Object)handler, this.params.getParameters().get("listDelimiterHandler"));
    }

    @Test
    void testSetLogger() {
        ConfigurationLogger log = (ConfigurationLogger)Mockito.mock(ConfigurationLogger.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setLogger(log));
        Assertions.assertSame((Object)log, this.params.getParameters().get("logger"));
    }

    @Test
    void testSetLookupsAndInterpolator() {
        Lookup look1 = (Lookup)Mockito.mock(Lookup.class);
        Lookup look2 = (Lookup)Mockito.mock(Lookup.class);
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        ConfigurationInterpolator ci = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        this.params.setDefaultLookups(Collections.singleton(look1));
        this.params.setPrefixLookups(Collections.singletonMap("test", look2));
        this.params.setInterpolator(ci);
        this.params.setParentInterpolator(parent);
        Map map = this.params.getParameters();
        Assertions.assertFalse((boolean)map.containsKey("prefixLookups"));
        Assertions.assertFalse((boolean)map.containsKey("defaultLookups"));
        Assertions.assertFalse((boolean)map.containsKey("parentInterpolator"));
    }

    @Test
    void testSetParentInterpolator() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setParentInterpolator(parent));
        Assertions.assertSame((Object)parent, this.params.getParameters().get("parentInterpolator"));
    }

    @Test
    void testSetPrefixLookups() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        Map<String, Lookup> lookups = Collections.singletonMap("test", look);
        Assertions.assertSame((Object)this.params, (Object)this.params.setPrefixLookups(lookups));
        Map map = (Map)this.params.getParameters().get("prefixLookups");
        Assertions.assertNotSame(lookups, (Object)map);
        Assertions.assertEquals(Collections.singletonMap("test", look), (Object)map);
        Map map2 = (Map)this.params.getParameters().get("prefixLookups");
        Assertions.assertNotSame((Object)map, (Object)map2);
    }

    @Test
    void testSetPrefixLookupsNull() {
        this.params.setPrefixLookups(new HashMap());
        this.params.setPrefixLookups(null);
        Assertions.assertFalse((boolean)this.params.getParameters().containsKey("prefixLookups"));
    }

    @Test
    void testSetSynchronizer() {
        Synchronizer sync = (Synchronizer)Mockito.mock(Synchronizer.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setSynchronizer(sync));
        Assertions.assertSame((Object)sync, this.params.getParameters().get("synchronizer"));
    }

    @Test
    void testSetThrowExceptionOnMissing() {
        Assertions.assertSame((Object)this.params, (Object)this.params.setThrowExceptionOnMissing(true));
        Assertions.assertEquals((Object)Boolean.TRUE, this.params.getParameters().get("throwExceptionOnMissing"));
    }
}

