/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.ListOrderedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListOrderedSet2Test<E>
extends AbstractSetTest<E> {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer THREE = 3;

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public ListOrderedSet<E> makeObject() {
        return new ListOrderedSet();
    }

    protected ListOrderedSet<E> setupSet() {
        ListOrderedSet<E> set = this.makeObject();
        for (int i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        return set;
    }

    @Test
    public void testListAddIndexed() {
        ListOrderedSet<E> set = this.makeObject();
        set.add((Object)ZERO);
        set.add((Object)TWO);
        set.add(1, (Object)ONE);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        set.add(0, (Object)ONE);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(ZERO);
        list.add(TWO);
        set.addAll(0, list);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        list.add(0, THREE);
        set.remove((Object)TWO);
        set.addAll(1, list);
        Assertions.assertEquals((int)4, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)THREE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        Assertions.assertSame((Object)ONE, (Object)set.get(3));
    }

    @Test
    public void testListAddRemove() {
        ListOrderedSet<E> set = this.makeObject();
        List view = set.asList();
        set.add((Object)ZERO);
        set.add((Object)ONE);
        set.add((Object)TWO);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)ONE, (Object)set.get(1));
        Assertions.assertSame((Object)TWO, (Object)set.get(2));
        Assertions.assertEquals((int)3, (int)view.size());
        Assertions.assertSame((Object)ZERO, view.get(0));
        Assertions.assertSame((Object)ONE, view.get(1));
        Assertions.assertSame((Object)TWO, view.get(2));
        Assertions.assertEquals((int)0, (int)set.indexOf((Object)ZERO));
        Assertions.assertEquals((int)1, (int)set.indexOf((Object)ONE));
        Assertions.assertEquals((int)2, (int)set.indexOf((Object)TWO));
        set.remove(1);
        Assertions.assertEquals((int)2, (int)set.size());
        Assertions.assertSame((Object)ZERO, (Object)set.get(0));
        Assertions.assertSame((Object)TWO, (Object)set.get(1));
        Assertions.assertEquals((int)2, (int)view.size());
        Assertions.assertSame((Object)ZERO, view.get(0));
        Assertions.assertSame((Object)TWO, view.get(1));
    }

    @Test
    public void testOrdering() {
        int i;
        ListOrderedSet<E> set = this.setupSet();
        OrderedIterator it = set.iterator();
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
        for (i = 0; i < 10; i += 2) {
            Assertions.assertTrue((boolean)set.remove((Object)Integer.toString(i)), (String)"Must be able to remove int");
        }
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong after remove ");
        }
        for (i = 0; i < 10; ++i) {
            set.add((Object)Integer.toString(i));
        }
        Assertions.assertEquals((int)10, (int)set.size(), (String)"Size of set is wrong!");
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
        for (i = 0; i < 10; i += 2) {
            Assertions.assertEquals((Object)Integer.toString(i), it.next(), (String)"Sequence is wrong");
        }
    }
}

