/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.collections4.properties.PropertiesFactory;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmptyPropertiesTest {
    private String getFirstLine(String x) {
        return x.split("\\R", 2)[0];
    }

    private PrintStream newPrintStream(ByteArrayOutputStream baos) throws UnsupportedEncodingException {
        return new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());
    }

    private String removeLine2(ByteArrayOutputStream baos) {
        return this.removeLine2(this.toString(baos));
    }

    private String removeLine2(String x) {
        String[] s = x.split("\\R", 2);
        return s[0] + System.lineSeparator() + (s.length > 2 ? s[2] : "");
    }

    @Test
    public void testClear() {
        PropertiesFactory.EMPTY_PROPERTIES.clear();
        Assertions.assertEquals((int)0, (int)PropertiesFactory.EMPTY_PROPERTIES.size());
    }

    @Test
    public void testClone() {
        PropertiesFactory.EMPTY_PROPERTIES.clone();
        Assertions.assertEquals((int)0, (int)PropertiesFactory.EMPTY_PROPERTIES.size());
    }

    @Test
    public void testCompute() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.compute("key", (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> "foo")));
    }

    @Test
    public void testComputeIfAbsent() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.computeIfAbsent("key", (Function<? super Object, ?>)((Function<Object, Object>)k -> "foo")));
    }

    @Test
    public void testComputeIfPresent() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.computeIfPresent("key", (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> "foo")));
    }

    @Test
    public void testContains() {
        Assertions.assertFalse((boolean)PropertiesFactory.EMPTY_PROPERTIES.contains("foo"));
    }

    @Test
    public void testContainsKey() {
        Assertions.assertFalse((boolean)PropertiesFactory.EMPTY_PROPERTIES.containsKey("foo"));
    }

    @Test
    public void testContainsValue() {
        Assertions.assertFalse((boolean)PropertiesFactory.EMPTY_PROPERTIES.containsValue("foo"));
    }

    @Test
    public void testElements() {
        Assertions.assertFalse((boolean)PropertiesFactory.EMPTY_PROPERTIES.elements().hasMoreElements());
    }

    @Test
    public void testEntrySet() {
        Assertions.assertTrue((boolean)PropertiesFactory.EMPTY_PROPERTIES.entrySet().isEmpty());
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)PropertiesFactory.EMPTY_PROPERTIES, (Object)PropertiesFactory.EMPTY_PROPERTIES);
        Assertions.assertEquals((Object)PropertiesFactory.EMPTY_PROPERTIES, (Object)new Properties());
        Assertions.assertEquals((Object)new Properties(), (Object)PropertiesFactory.EMPTY_PROPERTIES);
        Assertions.assertNotEquals(null, (Object)PropertiesFactory.EMPTY_PROPERTIES);
        Properties p = new Properties();
        p.put("Key", "Value");
        Assertions.assertNotEquals((Object)PropertiesFactory.EMPTY_PROPERTIES, (Object)p);
        Assertions.assertNotEquals((Object)p, (Object)PropertiesFactory.EMPTY_PROPERTIES);
    }

    @Test
    public void testForEach() {
        PropertiesFactory.EMPTY_PROPERTIES.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> Assertions.fail()));
    }

    @Test
    public void testGet() {
        Assertions.assertNull((Object)PropertiesFactory.EMPTY_PROPERTIES.get("foo"));
    }

    @Test
    public void testGetOrDefault() {
        Assertions.assertEquals((Object)"bar", (Object)PropertiesFactory.EMPTY_PROPERTIES.getOrDefault((Object)"foo", "bar"));
    }

    @Test
    public void testGetProperty() {
        Assertions.assertNull((Object)PropertiesFactory.EMPTY_PROPERTIES.getProperty("foo"));
    }

    @Test
    public void testGetPropertyDefault() {
        Assertions.assertEquals((Object)"bar", (Object)PropertiesFactory.EMPTY_PROPERTIES.getProperty("foo", "bar"));
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)PropertiesFactory.EMPTY_PROPERTIES.hashCode(), (int)PropertiesFactory.EMPTY_PROPERTIES.hashCode());
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)PropertiesFactory.EMPTY_PROPERTIES.isEmpty());
    }

    @Test
    public void testKeys() {
        Assertions.assertFalse((boolean)PropertiesFactory.EMPTY_PROPERTIES.keys().hasMoreElements());
    }

    @Test
    public void testKeySet() {
        Assertions.assertTrue((boolean)PropertiesFactory.EMPTY_PROPERTIES.isEmpty());
    }

    @Test
    public void testListToPrintStream() {
        ByteArrayOutputStream actual = new ByteArrayOutputStream();
        PropertiesFactory.EMPTY_PROPERTIES.list(new PrintStream(actual));
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        PropertiesFactory.INSTANCE.createProperties().list(new PrintStream(expected));
        Assertions.assertArrayEquals((byte[])expected.toByteArray(), (byte[])actual.toByteArray());
        expected.reset();
        new Properties().list(new PrintStream(expected));
        Assertions.assertArrayEquals((byte[])expected.toByteArray(), (byte[])actual.toByteArray());
    }

    @Test
    public void testListToPrintWriter() {
        ByteArrayOutputStream actual = new ByteArrayOutputStream();
        PropertiesFactory.EMPTY_PROPERTIES.list(new PrintWriter(actual));
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        PropertiesFactory.INSTANCE.createProperties().list(new PrintWriter(expected));
        Assertions.assertArrayEquals((byte[])expected.toByteArray(), (byte[])actual.toByteArray());
        expected.reset();
        new Properties().list(new PrintWriter(expected));
        Assertions.assertArrayEquals((byte[])expected.toByteArray(), (byte[])actual.toByteArray());
    }

    @Test
    public void testLoadFromXML() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.loadFromXML(new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY)));
    }

    @Test
    public void testLoadInputStream() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.load(new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY)));
    }

    @Test
    public void testLoadReader() throws IOException {
        try (NullReader reader = new NullReader(0L);){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.load((Reader)reader));
        }
    }

    @Test
    public void testMerge() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.merge("key", "value", (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> "foo")));
    }

    @Test
    public void testPropertyName() {
        Assertions.assertFalse((boolean)PropertiesFactory.EMPTY_PROPERTIES.propertyNames().hasMoreElements());
    }

    @Test
    public void testPut() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.put("Key", "Value"));
    }

    @Test
    public void testPutAll() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.putAll((Map<?, ?>)new HashMap()));
    }

    @Test
    public void testPutIfAbsent() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.putIfAbsent("Key", "Value"));
    }

    @Test
    public void testRehash() {
    }

    @Test
    public void testRemove() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.remove("key", "value"));
    }

    @Test
    public void testRemoveKey() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.remove("key"));
    }

    @Test
    public void testReplace() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.replace("key", "value1"));
    }

    @Test
    public void testReplaceAll() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> "value1")));
    }

    @Test
    public void testReplaceOldValue() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.replace("key", "value1", "value2"));
    }

    @Test
    public void testSave() throws IOException {
        String comments = "Hello world!";
        try (ByteArrayOutputStream actual = new ByteArrayOutputStream();
             ByteArrayOutputStream expected = new ByteArrayOutputStream();){
            PropertiesFactory.EMPTY_PROPERTIES.store(actual, "Hello world!");
            PropertiesFactory.INSTANCE.createProperties().store(expected, "Hello world!");
            String expectedComment = this.getFirstLine(expected.toString(StandardCharsets.UTF_8.name()));
            String actualComment = this.getFirstLine(actual.toString(StandardCharsets.UTF_8.name()));
            Assertions.assertEquals((Object)expectedComment, (Object)actualComment, () -> String.format("Expected String '%s' with length '%s'", expectedComment, expectedComment.length()));
            expected.reset();
            try (PrintStream out = new PrintStream(expected);){
                new Properties().store(out, "Hello world!");
            }
            String[] expectedLines = expected.toString(StandardCharsets.UTF_8.displayName()).split("\\n");
            String[] actualLines = actual.toString(StandardCharsets.UTF_8.displayName()).split("\\n");
            Assertions.assertEquals((int)expectedLines.length, (int)actualLines.length);
            Assertions.assertEquals((Object)expectedLines[0], (Object)actualLines[0]);
        }
    }

    @Test
    public void testSetProperty() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> PropertiesFactory.EMPTY_PROPERTIES.setProperty("Key", "Value"));
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)0, (int)PropertiesFactory.EMPTY_PROPERTIES.size());
    }

    @Test
    public void testStoreToOutputStream() throws IOException {
        String comments = "Hello world!";
        ByteArrayOutputStream actual = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(actual);){
            PropertiesFactory.EMPTY_PROPERTIES.store(ps, "Hello world!");
        }
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(expected);){
            PropertiesFactory.INSTANCE.createProperties().store(ps, "Hello world!");
        }
        Assertions.assertEquals((Object)this.removeLine2(expected), (Object)this.removeLine2(actual));
        expected.reset();
        ps = this.newPrintStream(expected);
        try {
            new Properties().store(ps, "Hello world!");
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        Assertions.assertEquals((Object)this.removeLine2(expected), (Object)this.removeLine2(actual), () -> this.removeLine2(actual));
    }

    @Test
    public void testStoreToPrintWriter() throws IOException {
        String comments = "Hello world!";
        ByteArrayOutputStream actual = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(actual);){
            PropertiesFactory.EMPTY_PROPERTIES.store(ps, "Hello world!");
        }
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(expected);){
            PropertiesFactory.INSTANCE.createProperties().store(ps, "Hello world!");
        }
        Assertions.assertEquals((Object)this.removeLine2(expected), (Object)this.removeLine2(actual));
        expected.reset();
        ps = this.newPrintStream(expected);
        try {
            new Properties().store(ps, "Hello world!");
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        Assertions.assertEquals((Object)this.removeLine2(expected), (Object)this.removeLine2(actual));
    }

    @Test
    public void testStoreToXMLOutputStream() throws IOException {
        String comments = "Hello world!";
        ByteArrayOutputStream actual = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(actual);){
            PropertiesFactory.EMPTY_PROPERTIES.storeToXML(ps, "Hello world!");
        }
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(expected);){
            PropertiesFactory.INSTANCE.createProperties().storeToXML(ps, "Hello world!");
        }
        Assertions.assertEquals((Object)this.toString(expected), (Object)this.toString(actual));
        expected.reset();
        ps = new PrintStream(expected);
        try {
            new Properties().storeToXML(ps, "Hello world!");
        }
        finally {
            ps.close();
        }
        Assertions.assertEquals((Object)this.removeLine2(expected), (Object)this.removeLine2(actual));
    }

    @Test
    public void testStoreToXMLOutputStreamWithEncoding() throws IOException {
        String comments = "Hello world!";
        String encoding = StandardCharsets.UTF_8.name();
        ByteArrayOutputStream actual = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(actual);){
            PropertiesFactory.EMPTY_PROPERTIES.storeToXML((OutputStream)ps, "Hello world!", encoding);
        }
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        try (PrintStream ps = this.newPrintStream(expected);){
            PropertiesFactory.INSTANCE.createProperties().storeToXML((OutputStream)ps, "Hello world!", encoding);
        }
        Assertions.assertEquals((Object)this.removeLine2(expected), (Object)this.removeLine2(actual));
        expected.reset();
        ps = this.newPrintStream(expected);
        try {
            new Properties().storeToXML((OutputStream)ps, "Hello world!", encoding);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        Assertions.assertEquals((Object)this.removeLine2(expected), (Object)this.removeLine2(actual));
    }

    @Test
    public void testStringPropertyName() {
        Assertions.assertTrue((boolean)PropertiesFactory.EMPTY_PROPERTIES.stringPropertyNames().isEmpty());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)new Properties().toString(), (Object)PropertiesFactory.EMPTY_PROPERTIES.toString());
    }

    @Test
    public void testValues() {
        Assertions.assertTrue((boolean)PropertiesFactory.EMPTY_PROPERTIES.isEmpty());
    }

    private String toString(ByteArrayOutputStream expected) {
        return new String(expected.toByteArray(), StandardCharsets.UTF_8);
    }
}

