/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.Map;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultMapEntryTest<K, V>
extends AbstractMapEntryTest<K, V> {
    @Override
    public Map.Entry<K, V> makeMapEntry() {
        return new DefaultMapEntry(null, null);
    }

    @Override
    public Map.Entry<K, V> makeMapEntry(K key, V value) {
        return new DefaultMapEntry(key, value);
    }

    @Override
    @Test
    public void testConstructors() {
        DefaultMapEntry entry = new DefaultMapEntry((Object)"name", (Object)"duke");
        Assertions.assertSame((Object)"name", entry.getKey());
        Assertions.assertSame((Object)"duke", entry.getValue());
        DefaultKeyValue pair = new DefaultKeyValue((Object)"name", (Object)"duke");
        Assertions.assertSame((Object)"name", (Object)pair.getKey());
        Assertions.assertSame((Object)"duke", (Object)pair.getValue());
        DefaultMapEntry entry2 = new DefaultMapEntry((Map.Entry)entry);
        Assertions.assertSame((Object)"name", entry2.getKey());
        Assertions.assertSame((Object)"duke", entry2.getValue());
        entry.setValue(null);
        Assertions.assertSame((Object)"duke", entry2.getValue());
    }

    @Override
    @Test
    public void testSelfReferenceHandling() {
        Map.Entry<K, Map.Entry<K, V>> entry = this.makeMapEntry();
        entry.setValue(entry);
        Assertions.assertSame(entry, entry.getValue());
    }
}

