/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.metadata;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.MetadataUpdater;
import org.apache.distributedlog.util.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSegmentMetadataStoreUpdater
implements MetadataUpdater {
    static final Logger LOG = LoggerFactory.getLogger(LogSegmentMetadataStoreUpdater.class);
    protected final LogSegmentMetadataStore metadataStore;
    protected final LogSegmentMetadata.LogSegmentMetadataVersion metadataVersion;

    public static MetadataUpdater createMetadataUpdater(DistributedLogConfiguration conf, LogSegmentMetadataStore metadataStore) {
        return new LogSegmentMetadataStoreUpdater(conf, metadataStore);
    }

    protected LogSegmentMetadataStoreUpdater(DistributedLogConfiguration conf, LogSegmentMetadataStore metadataStore) {
        this.metadataStore = metadataStore;
        this.metadataVersion = LogSegmentMetadata.LogSegmentMetadataVersion.of(conf.getDLLedgerMetadataLayoutVersion());
    }

    private String formatLogSegmentSequenceNumber(long logSegmentSeqNo) {
        return String.format("%018d", logSegmentSeqNo);
    }

    @Override
    public Transaction<Object> transaction() {
        return this.metadataStore.transaction();
    }

    @Override
    public CompletableFuture<LogSegmentMetadata> updateLastRecord(LogSegmentMetadata segment, LogRecordWithDLSN record) {
        DLSN dlsn = record.getDlsn();
        Preconditions.checkState((!segment.isInProgress() ? 1 : 0) != 0, (Object)"Updating last dlsn for an inprogress log segment isn't supported.");
        Preconditions.checkArgument((boolean)segment.isDLSNinThisSegment(dlsn), (Object)("DLSN " + dlsn + " doesn't belong to segment " + segment));
        LogSegmentMetadata newSegment = segment.mutator().setLastDLSN(dlsn).setLastTxId(record.getTransactionId()).setRecordCount((LogRecord)record).build();
        return this.updateSegmentMetadata(newSegment);
    }

    @Override
    public CompletableFuture<LogSegmentMetadata> changeSequenceNumber(LogSegmentMetadata segment, long logSegmentSeqNo) {
        String newZkPath = segment.getZkPath().replace(this.formatLogSegmentSequenceNumber(segment.getLogSegmentSequenceNumber()), this.formatLogSegmentSequenceNumber(logSegmentSeqNo));
        LogSegmentMetadata newSegment = segment.mutator().setLogSegmentSequenceNumber(logSegmentSeqNo).setZkPath(newZkPath).build();
        return this.addNewSegmentAndDeleteOldSegment(newSegment, segment);
    }

    @Override
    public CompletableFuture<LogSegmentMetadata> setLogSegmentActive(LogSegmentMetadata segment) {
        LogSegmentMetadata newSegment = segment.mutator().setTruncationStatus(LogSegmentMetadata.TruncationStatus.ACTIVE).build();
        return this.addNewSegmentAndDeleteOldSegment(newSegment, segment);
    }

    @Override
    public CompletableFuture<LogSegmentMetadata> setLogSegmentTruncated(LogSegmentMetadata segment) {
        LogSegmentMetadata newSegment = segment.mutator().setTruncationStatus(LogSegmentMetadata.TruncationStatus.TRUNCATED).build();
        return this.addNewSegmentAndDeleteOldSegment(newSegment, segment);
    }

    @Override
    public LogSegmentMetadata setLogSegmentTruncated(Transaction<Object> txn, LogSegmentMetadata segment) {
        LogSegmentMetadata newSegment = segment.mutator().setTruncationStatus(LogSegmentMetadata.TruncationStatus.TRUNCATED).build();
        this.addNewSegmentAndDeleteOldSegment(txn, newSegment, segment);
        return newSegment;
    }

    @Override
    public CompletableFuture<LogSegmentMetadata> setLogSegmentPartiallyTruncated(LogSegmentMetadata segment, DLSN minActiveDLSN) {
        LogSegmentMetadata newSegment = segment.mutator().setTruncationStatus(LogSegmentMetadata.TruncationStatus.PARTIALLY_TRUNCATED).setMinActiveDLSN(minActiveDLSN).build();
        return this.addNewSegmentAndDeleteOldSegment(newSegment, segment);
    }

    @Override
    public LogSegmentMetadata setLogSegmentPartiallyTruncated(Transaction<Object> txn, LogSegmentMetadata segment, DLSN minActiveDLSN) {
        LogSegmentMetadata newSegment = segment.mutator().setTruncationStatus(LogSegmentMetadata.TruncationStatus.PARTIALLY_TRUNCATED).setMinActiveDLSN(minActiveDLSN).build();
        this.addNewSegmentAndDeleteOldSegment(txn, newSegment, segment);
        return newSegment;
    }

    protected CompletableFuture<LogSegmentMetadata> updateSegmentMetadata(LogSegmentMetadata segment) {
        Transaction<Object> txn = this.transaction();
        this.metadataStore.updateLogSegment(txn, segment);
        return txn.execute().thenApply(value -> segment);
    }

    protected CompletableFuture<LogSegmentMetadata> addNewSegmentAndDeleteOldSegment(LogSegmentMetadata newSegment, LogSegmentMetadata oldSegment) {
        LOG.info("old segment {} new segment {}", (Object)oldSegment, (Object)newSegment);
        Transaction<Object> txn = this.transaction();
        this.addNewSegmentAndDeleteOldSegment(txn, newSegment, oldSegment);
        return txn.execute().thenApply(value -> newSegment);
    }

    protected void addNewSegmentAndDeleteOldSegment(Transaction<Object> txn, LogSegmentMetadata newSegment, LogSegmentMetadata oldSegment) {
        this.metadataStore.deleteLogSegment(txn, oldSegment, null);
        this.metadataStore.createLogSegment(txn, newSegment, null);
    }
}

