/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.xop;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.xop.AbstractXOPEncodingFilterHandler;
import org.apache.axiom.ext.stax.BlobProvider;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.om.impl.stream.xop.ContentIDGenerator;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicy;
import org.apache.axiom.om.impl.stream.xop.XOPHandler;

public final class XOPEncodingFilterHandler
extends AbstractXOPEncodingFilterHandler
implements XOPHandler,
OMAttachmentAccessor {
    private final Map<String, Object> blobObjects = new LinkedHashMap<String, Object>();
    private final ContentIDGenerator contentIDGenerator;
    private final OptimizationPolicy optimizationPolicy;

    public XOPEncodingFilterHandler(XmlHandler parent, ContentIDGenerator contentIDGenerator, OptimizationPolicy optimizationPolicy) {
        super(parent);
        this.contentIDGenerator = contentIDGenerator;
        this.optimizationPolicy = optimizationPolicy;
    }

    @Override
    public String prepareBlob(Blob blob) {
        boolean doOptimize;
        try {
            doOptimize = this.optimizationPolicy.isOptimized(blob, true);
        }
        catch (IOException ex) {
            doOptimize = true;
        }
        if (doOptimize) {
            String contentID = this.contentIDGenerator.generateContentID(null);
            this.blobObjects.put(contentID, blob);
            return contentID;
        }
        return null;
    }

    public Set<String> getContentIDs() {
        return Collections.unmodifiableSet(this.blobObjects.keySet());
    }

    public Blob getBlob(String contentID) {
        Object blobObject = this.blobObjects.get(contentID);
        if (blobObject == null) {
            return null;
        }
        if (blobObject instanceof Blob) {
            return (Blob)blobObject;
        }
        try {
            return ((BlobProvider)blobObject).getBlob();
        }
        catch (IOException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    @Override
    protected String processCharacterData(Object data) throws StreamException {
        TextContent textContent;
        if (data instanceof TextContent && (textContent = (TextContent)data).isBinary()) {
            boolean optimize;
            Object blobObject = textContent.getBlobObject();
            try {
                optimize = blobObject instanceof BlobProvider ? this.optimizationPolicy.isOptimized((BlobProvider)blobObject, textContent.isOptimize()) : this.optimizationPolicy.isOptimized((Blob)blobObject, textContent.isOptimize());
            }
            catch (IOException ex) {
                throw new StreamException(ex);
            }
            if (optimize) {
                String contentID = this.contentIDGenerator.generateContentID(textContent.getContentID());
                this.blobObjects.put(contentID, blobObject);
                return contentID;
            }
        }
        return null;
    }
}

