/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.Writer;
import org.jibx.runtime.ICharacterEscaper;

public class UTF8Escaper
implements ICharacterEscaper {
    private static final UTF8Escaper s_instance = new UTF8Escaper();

    private UTF8Escaper() {
    }

    @Override
    public void writeAttribute(String text, Writer writer) throws IOException {
        int mark = 0;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr == '\"') {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&quot;");
                continue;
            }
            if (chr == '&') {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&amp;");
                continue;
            }
            if (chr == '<') {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&lt;");
                continue;
            }
            if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                writer.write(text, mark, i - mark - 2);
                mark = i + 1;
                writer.write("]]&gt;");
                continue;
            }
            if (!(chr < ' ' ? chr != '\t' && chr != '\n' && chr != '\r' : chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff'))) continue;
            throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in attribute value text");
        }
        writer.write(text, mark, text.length() - mark);
    }

    @Override
    public void writeContent(String text, Writer writer) throws IOException {
        int mark = 0;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr == '&') {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&amp;");
                continue;
            }
            if (chr == '<') {
                writer.write(text, mark, i - mark);
                mark = i + 1;
                writer.write("&lt;");
                continue;
            }
            if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                writer.write(text, mark, i - mark - 2);
                mark = i + 1;
                writer.write("]]&gt;");
                continue;
            }
            if (!(chr < ' ' ? chr != '\t' && chr != '\n' && chr != '\r' : chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff' || chr > '\u10ffff'))) continue;
            throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in content text");
        }
        writer.write(text, mark, text.length() - mark);
    }

    @Override
    public void writeCData(String text, Writer writer) throws IOException {
        writer.write("<![CDATA[");
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr == '>' && i > 2 && text.charAt(i - 1) == ']' && text.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (!(chr < ' ' ? chr != '\t' && chr != '\n' && chr != '\r' : chr > '\ud7ff' && (chr < '\ue000' || chr == '\ufffe' || chr == '\uffff'))) continue;
            throw new IOException("Illegal character code 0x" + Integer.toHexString(chr) + " in CDATA section");
        }
        writer.write(text);
        writer.write("]]>");
    }

    public static ICharacterEscaper getInstance() {
        return s_instance;
    }
}

