/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.comp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.openjdk.tools.javac.code.AnnoConstruct;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Attr;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.DeferredAttr;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.InferenceContext;
import org.openjdk.tools.javac.comp.Resolve;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Filter;
import org.openjdk.tools.javac.util.GraphUtils;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.Pair;
import org.openjdk.tools.javac.util.StringUtils;
import org.openjdk.tools.javac.util.Warner;

public class Infer {
    protected static final Context.Key<Infer> inferKey = new Context.Key();
    Resolve rs;
    Check chk;
    Symtab syms;
    Types types;
    JCDiagnostic.Factory diags;
    Log log;
    boolean allowGraphInference;
    private final String dependenciesFolder;
    private List<String> pendingGraphs;
    public static final Type anyPoly = new Type.JCNoType();
    protected final InferenceException inferenceException;
    Types.TypeMapping<Void> fromTypeVarFun = new Type.StructuralTypeMapping<Void>(){

        @Override
        public Type visitTypeVar(Type.TypeVar typeVar, Void void_) {
            Type.UndetVar undetVar = new Type.UndetVar(typeVar, Infer.this.incorporationEngine(), Infer.this.types);
            if ((typeVar.tsym.flags() & 0x800000000000L) != 0L) {
                undetVar.setThrow();
            }
            return undetVar;
        }
    };
    AbstractIncorporationEngine legacyEngine = new AbstractIncorporationEngine(){

        @Override
        List<IncorporationAction> getIncorporationActions(Type.UndetVar undetVar, Type.UndetVar.InferenceBound inferenceBound, Type type, boolean bl) {
            ListBuffer<CheckBounds> listBuffer = new ListBuffer<CheckBounds>();
            Type type2 = undetVar.getInst();
            if (type2 != null) {
                listBuffer.add(new CheckInst(undetVar, inferenceBound, new Type.UndetVar.InferenceBound[0]));
            }
            listBuffer.add(new EqCheckLegacy(undetVar, type, inferenceBound));
            return listBuffer.toList();
        }
    };
    AbstractIncorporationEngine graphEngine = new AbstractIncorporationEngine(){

        @Override
        List<IncorporationAction> getIncorporationActions(Type.UndetVar undetVar, Type.UndetVar.InferenceBound inferenceBound, Type type, boolean bl) {
            ListBuffer<IncorporationAction> listBuffer = new ListBuffer<IncorporationAction>();
            Type type2 = undetVar.getInst();
            if (type2 != null) {
                listBuffer.add(new CheckInst(undetVar, inferenceBound, new Type.UndetVar.InferenceBound[0]));
            }
            listBuffer.add(new CheckBounds(undetVar, type, inferenceBound));
            if (bl) {
                return listBuffer.toList();
            }
            if (inferenceBound == Type.UndetVar.InferenceBound.UPPER) {
                listBuffer.add(new CheckUpperBounds(undetVar, type));
            }
            listBuffer.add(new PropagateBounds(undetVar, type, inferenceBound));
            return listBuffer.toList();
        }
    };
    static final int MAX_INCORPORATION_STEPS = 10000;
    Map<IncorporationBinaryOp, Boolean> incorporationCache = new HashMap<IncorporationBinaryOp, Boolean>();
    final InferenceContext emptyContext;

    public static Infer instance(Context context) {
        Infer infer = context.get(inferKey);
        if (infer == null) {
            infer = new Infer(context);
        }
        return infer;
    }

    protected Infer(Context context) {
        context.put(inferKey, this);
        this.rs = Resolve.instance(context);
        this.chk = Check.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.inferenceException = new InferenceException(this.diags);
        Options options = Options.instance(context);
        this.allowGraphInference = Source.instance(context).allowGraphInference() && options.isUnset("useLegacyInference");
        this.dependenciesFolder = options.get("debug.dumpInferenceGraphsTo");
        this.pendingGraphs = List.nil();
        this.emptyContext = new InferenceContext(this, List.nil());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type instantiateMethod(Env<AttrContext> env, List<Type> list, Type.MethodType methodType, Attr.ResultInfo resultInfo, Symbol.MethodSymbol methodSymbol, List<Type> list2, boolean bl, boolean bl2, Resolve.MethodResolutionContext methodResolutionContext, Warner warner) throws InferenceException {
        InferenceContext inferenceContext = new InferenceContext(this, list);
        this.inferenceException.clear();
        try {
            DeferredAttr.DeferredAttrContext deferredAttrContext = methodResolutionContext.deferredAttrContext(methodSymbol, inferenceContext, resultInfo, warner);
            methodResolutionContext.methodCheck.argumentsAcceptable(env, deferredAttrContext, list2, (List<Type>)methodType.getParameterTypes(), warner);
            if (this.allowGraphInference && resultInfo != null && resultInfo.pt == anyPoly) {
                this.doIncorporation(inferenceContext, warner);
                PartiallyInferredMethodType partiallyInferredMethodType = new PartiallyInferredMethodType(methodType, inferenceContext, env, warner);
                return partiallyInferredMethodType;
            }
            if (this.allowGraphInference && resultInfo != null) {
                this.doIncorporation(inferenceContext, warner);
                if (!warner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                    boolean bl3 = this.shouldPropagate(methodType.getReturnType(), resultInfo, inferenceContext);
                    InferenceContext inferenceContext2 = bl3 ? inferenceContext.min(this.roots(methodType, deferredAttrContext), true, warner) : inferenceContext;
                    Type type = this.generateReturnConstraints(env.tree, resultInfo, methodType, inferenceContext2);
                    methodType = (Type.MethodType)this.types.createMethodTypeWithReturn(methodType, type);
                    if (bl3) {
                        inferenceContext2.dupTo(resultInfo.checkContext.inferenceContext());
                        deferredAttrContext.complete();
                        Type.MethodType methodType2 = methodType;
                        return methodType2;
                    }
                }
            }
            deferredAttrContext.complete();
            if (this.allowGraphInference) {
                inferenceContext.solve(warner);
            } else {
                inferenceContext.solveLegacy(true, warner, LegacyInferenceSteps.EQ_LOWER.steps);
            }
            methodType = (Type.MethodType)inferenceContext.asInstType(methodType);
            if (!this.allowGraphInference && inferenceContext.restvars().nonEmpty() && resultInfo != null && !warner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                this.generateReturnConstraints(env.tree, resultInfo, methodType, inferenceContext);
                inferenceContext.solveLegacy(false, warner, LegacyInferenceSteps.EQ_UPPER.steps);
                methodType = (Type.MethodType)inferenceContext.asInstType(methodType);
            }
            if (resultInfo != null && this.rs.verboseResolutionMode.contains((Object)Resolve.VerboseResolutionMode.DEFERRED_INST)) {
                this.log.note(env.tree.pos, "deferred.method.inst", methodSymbol, methodType, resultInfo.pt);
            }
            Type.MethodType methodType3 = methodType;
            return methodType3;
        }
        finally {
            if (resultInfo != null || !this.allowGraphInference) {
                inferenceContext.notifyChange();
            } else {
                inferenceContext.notifyChange(inferenceContext.boundedVars());
            }
            if (resultInfo == null) {
                inferenceContext.captureTypeCache.clear();
            }
            this.dumpGraphsIfNeeded(env.tree, methodSymbol, methodResolutionContext);
        }
    }

    private boolean shouldPropagate(Type type, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        return resultInfo.checkContext.inferenceContext() != this.emptyContext && inferenceContext.free(type) && (!inferenceContext.inferencevars.contains(type) || !this.needsEagerInstantiation((Type.UndetVar)inferenceContext.asUndetVar(type), resultInfo.pt, inferenceContext));
    }

    private List<Type> roots(Type.MethodType methodType, DeferredAttr.DeferredAttrContext deferredAttrContext) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        listBuffer.add(methodType.getReturnType());
        if (deferredAttrContext != null && deferredAttrContext.mode == DeferredAttr.AttrMode.CHECK) {
            listBuffer.addAll(methodType.getThrownTypes());
            for (DeferredAttr.DeferredAttrNode deferredAttrNode : deferredAttrContext.deferredAttrNodes) {
                listBuffer.addAll((Collection<Type>)deferredAttrNode.deferredStuckPolicy.stuckVars());
                listBuffer.addAll((Collection<Type>)deferredAttrNode.deferredStuckPolicy.depVars());
            }
        }
        return listBuffer.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpGraphsIfNeeded(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Resolve.MethodResolutionContext methodResolutionContext) {
        int n = 0;
        try {
            for (String string : this.pendingGraphs.reverse()) {
                Assert.checkNonNull(this.dependenciesFolder);
                Name name = symbol.name == symbol.name.table.names.init ? symbol.owner.name : symbol.name;
                String string2 = String.format("%s@%s[mode=%s,step=%s]_%d.dot", new Object[]{name, diagnosticPosition.getStartPosition(), methodResolutionContext.attrMode(), methodResolutionContext.step, n});
                Path path = Paths.get(this.dependenciesFolder, string2);
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedWriter.append(string);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            Assert.error("Error occurred when dumping inference graph: " + iOException.getMessage());
        }
        finally {
            this.pendingGraphs = List.nil();
        }
    }

    Type generateReturnConstraints(JCTree jCTree, Attr.ResultInfo resultInfo, Type.MethodType methodType, InferenceContext inferenceContext) {
        Type type3;
        InferenceContext inferenceContext2 = resultInfo.checkContext.inferenceContext();
        Type type2 = methodType.getReturnType();
        if (methodType.getReturnType().containsAny(inferenceContext.inferencevars) && inferenceContext2 != this.emptyContext) {
            type2 = this.types.capture(type2);
            for (Type type3 : type2.getTypeArguments()) {
                if (!type3.hasTag(TypeTag.TYPEVAR) || !((Type.TypeVar)type3).isCaptured()) continue;
                inferenceContext.addVar((Type.TypeVar)type3);
            }
        }
        Object object = inferenceContext.asUndetVar(type2);
        type3 = resultInfo.pt;
        if (((Type)object).hasTag(TypeTag.VOID)) {
            type3 = this.syms.voidType;
        } else if (type3.hasTag(TypeTag.NONE)) {
            type3 = type2.isPrimitive() ? type2 : this.syms.objectType;
        } else if (((Type)object).hasTag(TypeTag.UNDETVAR)) {
            if (this.needsEagerInstantiation((Type.UndetVar)object, type3, inferenceContext) && (this.allowGraphInference || !type3.isPrimitive())) {
                type3 = this.generateReferenceToTargetConstraint(jCTree, (Type.UndetVar)object, type3, resultInfo, inferenceContext);
            }
        } else if (inferenceContext2.free(resultInfo.pt)) {
            object = inferenceContext.asUndetVar(inferenceContext2.cachedCapture(jCTree, type2, !resultInfo.checkMode.updateTreeType()));
        }
        Assert.check(this.allowGraphInference || !inferenceContext2.free(type3), "legacy inference engine cannot handle constraints on both sides of a subtyping assertion");
        Warner warner = new Warner();
        if (!resultInfo.checkContext.compatible((Type)object, inferenceContext2.asUndetVar(type3), warner) || !this.allowGraphInference && warner.hasLint(Lint.LintCategory.UNCHECKED)) {
            throw this.inferenceException.setMessage("infer.no.conforming.instance.exists", inferenceContext.restvars(), methodType.getReturnType(), type3);
        }
        return type2;
    }

    private boolean needsEagerInstantiation(Type.UndetVar undetVar, Type type, InferenceContext inferenceContext) {
        Object object;
        if (type.isPrimitive()) {
            for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.values())) {
                Type type3 = this.types.unboxedType(type2);
                if (type3 == null || type3.hasTag(TypeTag.NONE)) continue;
                return true;
            }
            return false;
        }
        Type type4 = this.types.capture(type);
        if (type4 == type) {
            for (Type type5 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                object = this.types.capture(type5);
                if (object == type5) continue;
                return true;
            }
            for (Type type5 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                for (Type type6 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                    if (type5 == type6 || inferenceContext.free(type5) || inferenceContext.free(type6) || !this.commonSuperWithDiffParameterization(type5, type6)) continue;
                    return true;
                }
            }
        }
        if (type.isParameterized()) {
            for (Type type5 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                object = this.types.asSuper(type5, type.tsym);
                if (object == null || !((Type)object).isRaw()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean commonSuperWithDiffParameterization(Type type, Type type2) {
        for (Pair<Type, Type> pair : this.getParameterizedSupers(type, type2)) {
            if (this.types.isSameType((Type)pair.fst, (Type)pair.snd)) continue;
            return true;
        }
        return false;
    }

    private Type generateReferenceToTargetConstraint(JCTree jCTree, Type.UndetVar undetVar, Type type, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        inferenceContext.solve(List.of(undetVar.qtype), new Warner());
        inferenceContext.notifyChange();
        Type type2 = resultInfo.checkContext.inferenceContext().cachedCapture(jCTree, undetVar.getInst(), !resultInfo.checkMode.updateTreeType());
        if (this.types.isConvertible(type2, resultInfo.checkContext.inferenceContext().asUndetVar(type))) {
            return this.syms.objectType;
        }
        return type;
    }

    void instantiateAsUninferredVars(List<Type> list, InferenceContext inferenceContext) {
        AnnoConstruct annoConstruct;
        List<Type> list2;
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type object : list) {
            Type type = (Type.UndetVar)inferenceContext.asUndetVar(object);
            list2 = ((Type.UndetVar)type).getBounds(Type.UndetVar.InferenceBound.UPPER);
            if (Type.containsAny(list2, list)) {
                annoConstruct = new Symbol.TypeVariableSymbol(4096L, ((Type.UndetVar)type).qtype.tsym.name, null, ((Type.UndetVar)type).qtype.tsym.owner);
                ((Symbol.TypeSymbol)annoConstruct).type = new Type.TypeVar((Symbol.TypeSymbol)annoConstruct, this.types.makeIntersectionType(((Type.UndetVar)type).getBounds(Type.UndetVar.InferenceBound.UPPER)), null);
                listBuffer.append(type);
                ((Type.UndetVar)type).setInst(((Symbol.TypeSymbol)annoConstruct).type);
                continue;
            }
            if (list2.nonEmpty()) {
                ((Type.UndetVar)type).setInst(this.types.glb(list2));
                continue;
            }
            ((Type.UndetVar)type).setInst(this.syms.objectType);
        }
        List list3 = list;
        for (Type type : listBuffer) {
            list2 = type;
            annoConstruct = (Type.TypeVar)((Type.UndetVar)((Object)list2)).getInst();
            annoConstruct.bound = this.types.glb(inferenceContext.asInstTypes(this.types.getBounds((Type.TypeVar)annoConstruct)));
            if (annoConstruct.bound.isErroneous()) {
                this.reportBoundError((Type.UndetVar)((Object)list2), Type.UndetVar.InferenceBound.UPPER);
            }
            list3 = list3.tail;
        }
    }

    Type instantiatePolymorphicSignatureInstance(Env<AttrContext> env, Symbol.MethodSymbol methodSymbol, Resolve.MethodResolutionContext methodResolutionContext, List<Type> list) {
        Object object;
        Type type;
        Object object2;
        if (methodSymbol == null || this.types.isSameType(methodSymbol.getReturnType(), this.syms.objectType, true)) {
            switch (env.next.tree.getTag()) {
                case TYPECAST: {
                    object2 = (JCTree.JCTypeCast)env.next.tree;
                    type = TreeInfo.skipParens(((JCTree.JCTypeCast)object2).expr) == env.tree ? ((JCTree.JCTypeCast)object2).clazz.type : this.syms.objectType;
                    break;
                }
                case EXEC: {
                    object = (JCTree.JCExpressionStatement)env.next.tree;
                    type = TreeInfo.skipParens(((JCTree.JCExpressionStatement)object).expr) == env.tree ? this.syms.voidType : this.syms.objectType;
                    break;
                }
                default: {
                    type = this.syms.objectType;
                    break;
                }
            }
        } else {
            type = methodSymbol.getReturnType();
        }
        object2 = list.map(new ImplicitArgType(methodSymbol, methodResolutionContext.step));
        object = methodSymbol != null ? methodSymbol.getThrownTypes() : List.of(this.syms.throwableType);
        Type.MethodType methodType = new Type.MethodType((List<Type>)object2, type, (List<Type>)object, this.syms.methodClass);
        return methodType;
    }

    public Type instantiateFunctionalInterface(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<Type> list, Check.CheckContext checkContext) {
        if (this.types.capture(type) == type) {
            return type;
        }
        Type type3 = type.tsym.type;
        InferenceContext inferenceContext = new InferenceContext(this, type.tsym.type.getTypeArguments());
        Assert.check(list != null);
        List<Type> list2 = this.types.findDescriptorType(type3).getParameterTypes();
        if (list2.size() != list.size()) {
            checkContext.report(diagnosticPosition, this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
            return this.types.createErrorType(type);
        }
        for (Type object2 : list2) {
            if (!this.types.isSameType(inferenceContext.asUndetVar(object2), (Type)list.head)) {
                checkContext.report(diagnosticPosition, this.diags.fragment("no.suitable.functional.intf.inst", type));
                return this.types.createErrorType(type);
            }
            list = list.tail;
        }
        List list3 = type.getTypeArguments();
        for (Type type4 : inferenceContext.undetvars) {
            Type.UndetVar undetVar = (Type.UndetVar)type4;
            Optional<Type> optional = undetVar.getBounds(Type.UndetVar.InferenceBound.EQ).stream().filter(type2 -> !type2.containsAny(type3.getTypeArguments())).findFirst();
            undetVar.setInst(optional.orElse((Type)list3.head));
            list3 = list3.tail;
        }
        Type type5 = inferenceContext.asInstType(type3);
        if (!this.chk.checkValidGenericType(type5)) {
            checkContext.report(diagnosticPosition, this.diags.fragment("no.suitable.functional.intf.inst", type));
        }
        checkContext.compatible(type5, type, this.types.noWarnings);
        return type5;
    }

    AbstractIncorporationEngine incorporationEngine() {
        return this.allowGraphInference ? this.graphEngine : this.legacyEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIncorporation(InferenceContext inferenceContext, Warner warner) throws InferenceException {
        try {
            boolean bl = true;
            for (int i = 0; bl && i < 10000; ++i) {
                bl = false;
                for (Type type : inferenceContext.undetvars) {
                    Type.UndetVar undetVar = (Type.UndetVar)type;
                    if (undetVar.incorporationActions.isEmpty()) continue;
                    bl = true;
                    undetVar.incorporationActions.removeFirst().apply(inferenceContext, warner);
                }
            }
        }
        finally {
            this.incorporationCache.clear();
        }
    }

    private List<Pair<Type, Type>> getParameterizedSupers(Type type, Type type2) {
        Type type3 = this.types.lub(type, type2);
        if (type3 == this.syms.errType || type3 == this.syms.botType) {
            return List.nil();
        }
        List<Type> list = type3.isIntersection() ? ((Type.IntersectionClassType)type3).getComponents() : List.of(type3);
        ListBuffer<Pair<Type, Type>> listBuffer = new ListBuffer<Pair<Type, Type>>();
        for (Type type4 : list) {
            if (!type4.isParameterized()) continue;
            Type type5 = this.asSuper(type, type4);
            Type type6 = this.asSuper(type2, type4);
            listBuffer.add(new Pair<Type, Type>(type5, type6));
        }
        return listBuffer.toList();
    }

    private Type asSuper(Type type, Type type2) {
        return type2.hasTag(TypeTag.ARRAY) ? new Type.ArrayType(this.asSuper(this.types.elemtype(type), this.types.elemtype(type2)), this.syms.arrayClass) : this.types.asSuper(type, type2.tsym);
    }

    boolean doIncorporationOp(IncorporationBinaryOpKind incorporationBinaryOpKind, Type type, Type type2, Warner warner) {
        IncorporationBinaryOp incorporationBinaryOp = new IncorporationBinaryOp(incorporationBinaryOpKind, type, type2);
        Boolean bl = this.incorporationCache.get(incorporationBinaryOp);
        if (bl == null) {
            bl = incorporationBinaryOp.apply(warner);
            this.incorporationCache.put(incorporationBinaryOp, bl);
        }
        return bl;
    }

    void reportInstError(Type.UndetVar undetVar, Type.UndetVar.InferenceBound inferenceBound) {
        this.reportInferenceError(String.format("inferred.do.not.conform.to.%s.bounds", StringUtils.toLowerCase(inferenceBound.name())), undetVar.getInst(), undetVar.getBounds(inferenceBound));
    }

    void reportBoundError(Type.UndetVar undetVar, Type.UndetVar.InferenceBound inferenceBound) {
        this.reportInferenceError(String.format("incompatible.%s.bounds", StringUtils.toLowerCase(inferenceBound.name())), undetVar.qtype, undetVar.getBounds(inferenceBound));
    }

    void reportBoundError(Type.UndetVar undetVar, Type.UndetVar.InferenceBound inferenceBound, Type.UndetVar.InferenceBound inferenceBound2) {
        this.reportInferenceError(String.format("incompatible.%s.%s.bounds", StringUtils.toLowerCase(inferenceBound.name()), StringUtils.toLowerCase(inferenceBound2.name())), undetVar.qtype, undetVar.getBounds(inferenceBound), undetVar.getBounds(inferenceBound2));
    }

    void reportInferenceError(String string, Object ... objectArray) {
        throw this.inferenceException.setMessage(string, objectArray);
    }

    static interface FreeTypeListener {
        public void typesInferred(InferenceContext var1);
    }

    class GraphSolver {
        InferenceContext inferenceContext;
        Warner warn;

        GraphSolver(InferenceContext inferenceContext, Warner warner) {
            this.inferenceContext = inferenceContext;
            this.warn = warner;
        }

        void solve(GraphStrategy graphStrategy) {
            Infer.this.doIncorporation(this.inferenceContext, this.warn);
            InferenceGraph inferenceGraph = new InferenceGraph();
            while (!graphStrategy.done()) {
                if (Infer.this.dependenciesFolder != null) {
                    Infer.this.pendingGraphs = Infer.this.pendingGraphs.prepend(inferenceGraph.toDot());
                }
                InferenceGraph.Node node = graphStrategy.pickNode(inferenceGraph);
                List<Type> list = List.from((Iterable)node.data);
                List<Type> list2 = this.inferenceContext.save();
                try {
                    block3: while (Type.containsAny(this.inferenceContext.restvars(), list)) {
                        for (GraphInferenceSteps graphInferenceSteps : GraphInferenceSteps.values()) {
                            if (!this.inferenceContext.solveBasic(list, graphInferenceSteps.steps).nonEmpty()) continue;
                            Infer.this.doIncorporation(this.inferenceContext, this.warn);
                            continue block3;
                        }
                        throw Infer.this.inferenceException.setMessage();
                    }
                }
                catch (InferenceException inferenceException) {
                    this.inferenceContext.rollback(list2);
                    Infer.this.instantiateAsUninferredVars(list, this.inferenceContext);
                    Infer.this.doIncorporation(this.inferenceContext, this.warn);
                }
                inferenceGraph.deleteNode(node);
            }
        }

        class InferenceGraph {
            ArrayList<Node> nodes;

            InferenceGraph() {
                this.initNodes();
            }

            public Node findNode(Type type) {
                for (Node node : this.nodes) {
                    if (!((ListBuffer)node.data).contains(type)) continue;
                    return node;
                }
                return null;
            }

            public void deleteNode(Node node) {
                Assert.check(this.nodes.contains(node));
                this.nodes.remove(node);
                this.notifyUpdate(node, null);
            }

            void notifyUpdate(Node node, Node node2) {
                for (Node node3 : this.nodes) {
                    node3.graphChanged(node, node2);
                }
            }

            void initNodes() {
                this.nodes = new ArrayList();
                for (Type iterator : GraphSolver.this.inferenceContext.restvars()) {
                    this.nodes.add(new Node(iterator));
                }
                for (Node node : this.nodes) {
                    List<Node> list = (Type)((ListBuffer)node.data).first();
                    for (Node node2 : this.nodes) {
                        Type type = (Type)((ListBuffer)node2.data).first();
                        Type.UndetVar undetVar = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar((Type)((Object)list));
                        if (!Type.containsAny(undetVar.getBounds(Type.UndetVar.InferenceBound.values()), List.of(type))) continue;
                        node.addDependency(node2);
                    }
                }
                ArrayList arrayList = new ArrayList();
                for (List<Node> list : GraphUtils.tarjan(this.nodes)) {
                    if (list.length() > 1) {
                        Node node = (Node)list.head;
                        node.mergeWith(list.tail);
                        for (Node node3 : list) {
                            this.notifyUpdate(node3, node);
                        }
                    }
                    arrayList.add(list.head);
                }
                this.nodes = arrayList;
            }

            String toDot() {
                StringBuilder stringBuilder = new StringBuilder();
                for (Type type : GraphSolver.this.inferenceContext.undetvars) {
                    Type.UndetVar undetVar = (Type.UndetVar)type;
                    stringBuilder.append(String.format("var %s - upper bounds = %s, lower bounds = %s, eq bounds = %s\\n", undetVar.qtype, undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER), undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER), undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)));
                }
                return GraphUtils.toDot(this.nodes, "inferenceGraph" + this.hashCode(), stringBuilder.toString());
            }

            class Node
            extends GraphUtils.TarjanNode<ListBuffer<Type>, Node>
            implements GraphUtils.DottableNode<ListBuffer<Type>, Node> {
                Set<Node> deps;

                Node(Type type) {
                    super(ListBuffer.of(type));
                    this.deps = new HashSet<Node>();
                }

                @Override
                public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                    return new GraphUtils.DependencyKind[]{DependencyKind.BOUND};
                }

                @Override
                public Iterable<? extends Node> getAllDependencies() {
                    return this.deps;
                }

                @Override
                public Collection<? extends Node> getDependenciesByKind(GraphUtils.DependencyKind dependencyKind) {
                    if (dependencyKind == DependencyKind.BOUND) {
                        return this.deps;
                    }
                    throw new IllegalStateException();
                }

                protected void addDependency(Node node) {
                    this.deps.add(node);
                }

                protected void addDependencies(Set<Node> set) {
                    for (Node node : set) {
                        this.addDependency(node);
                    }
                }

                protected boolean removeDependency(Node node) {
                    return this.deps.remove(node);
                }

                protected Set<Node> closure() {
                    boolean bl = true;
                    HashSet<Node> hashSet = new HashSet<Node>();
                    hashSet.add(this);
                    while (bl) {
                        bl = false;
                        for (Node node : new HashSet<Node>(hashSet)) {
                            bl = hashSet.addAll(node.deps);
                        }
                    }
                    return hashSet;
                }

                protected boolean isLeaf() {
                    if (this.deps.isEmpty()) {
                        return true;
                    }
                    for (Node node : this.deps) {
                        if (node == this) continue;
                        return false;
                    }
                    return true;
                }

                protected void mergeWith(List<? extends Node> list) {
                    for (Node object : list) {
                        Assert.check(((ListBuffer)object.data).length() == 1, "Attempt to merge a compound node!");
                        ((ListBuffer)this.data).appendList((ListBuffer)object.data);
                        this.addDependencies(object.deps);
                    }
                    HashSet hashSet = new HashSet();
                    for (Node node : this.deps) {
                        if (((ListBuffer)this.data).contains(((ListBuffer)node.data).first())) {
                            hashSet.add(this);
                            continue;
                        }
                        hashSet.add(node);
                    }
                    this.deps = hashSet;
                }

                private void graphChanged(Node node, Node node2) {
                    if (this.removeDependency(node) && node2 != null) {
                        this.addDependency(node2);
                    }
                }

                @Override
                public Properties nodeAttributes() {
                    Properties properties = new Properties();
                    properties.put("label", "\"" + this.toString() + "\"");
                    return properties;
                }

                @Override
                public Properties dependencyAttributes(Node node, GraphUtils.DependencyKind dependencyKind) {
                    Properties properties = new Properties();
                    properties.put("style", ((DependencyKind)dependencyKind).dotSyle);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = "";
                    for (Type type : (ListBuffer)this.data) {
                        Type.UndetVar undetVar = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar(type);
                        for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.values())) {
                            if (!type2.containsAny(List.from((Iterable)node.data))) continue;
                            stringBuilder.append(string);
                            stringBuilder.append(type2);
                            string = ",";
                        }
                    }
                    properties.put("label", "\"" + stringBuilder.toString() + "\"");
                    return properties;
                }
            }
        }
    }

    static enum DependencyKind implements GraphUtils.DependencyKind
    {
        BOUND("dotted"),
        STUCK("dashed");

        final String dotSyle;

        private DependencyKind(String string2) {
            this.dotSyle = string2;
        }
    }

    static enum GraphInferenceSteps {
        EQ(EnumSet.of(InferenceStep.EQ)),
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_LOWER_THROWS_UPPER_CAPTURED(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER, InferenceStep.UPPER, InferenceStep.THROWS, InferenceStep.CAPTURED));

        final EnumSet<InferenceStep> steps;

        private GraphInferenceSteps(EnumSet<InferenceStep> enumSet) {
            this.steps = enumSet;
        }
    }

    static enum LegacyInferenceSteps {
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_UPPER(EnumSet.of(InferenceStep.EQ, InferenceStep.UPPER_LEGACY));

        final EnumSet<InferenceStep> steps;

        private LegacyInferenceSteps(EnumSet<InferenceStep> enumSet) {
            this.steps = enumSet;
        }
    }

    static enum InferenceStep {
        EQ(Type.UndetVar.InferenceBound.EQ){

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return (Type)this.filterBounds((Type.UndetVar)undetVar, (InferenceContext)inferenceContext).head;
            }
        }
        ,
        LOWER(Type.UndetVar.InferenceBound.LOWER){

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                Type type;
                Infer infer = inferenceContext.infer;
                List<Type> list = this.filterBounds(undetVar, inferenceContext);
                Type type2 = type = list.tail.tail == null ? (Type)list.head : infer.types.lub(list);
                if (type.isPrimitive() || type.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.minimal.instance.exists", undetVar.qtype, list);
                }
                return type;
            }
        }
        ,
        THROWS(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                if (!undetVar.isThrows()) {
                    return false;
                }
                Types types = inferenceContext.types;
                Symtab symtab = inferenceContext.infer.syms;
                return undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER).stream().filter(type -> !inferenceContext.free((Type)type)).allMatch(type -> types.isSubtype(symtab.runtimeExceptionType, (Type)type));
            }

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return inferenceContext.infer.syms.runtimeExceptionType;
            }
        }
        ,
        UPPER(Type.UndetVar.InferenceBound.UPPER){

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                Type type;
                Infer infer = inferenceContext.infer;
                List<Type> list = this.filterBounds(undetVar, inferenceContext);
                Type type2 = type = list.tail.tail == null ? (Type)list.head : infer.types.glb(list);
                if (type.isPrimitive() || type.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.maximal.instance.exists", undetVar.qtype, list);
                }
                return type;
            }
        }
        ,
        UPPER_LEGACY(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !inferenceContext.free(undetVar.getBounds(this.ib)) && !undetVar.isCaptured();
            }

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return UPPER.solve(undetVar, inferenceContext);
            }
        }
        ,
        CAPTURED(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return undetVar.isCaptured() && !inferenceContext.free(undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER, Type.UndetVar.InferenceBound.LOWER));
            }

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                Infer infer = inferenceContext.infer;
                Type type = UPPER.filterBounds(undetVar, inferenceContext).nonEmpty() ? UPPER.solve(undetVar, inferenceContext) : infer.syms.objectType;
                Type type2 = LOWER.filterBounds(undetVar, inferenceContext).nonEmpty() ? LOWER.solve(undetVar, inferenceContext) : infer.syms.botType;
                Type.CapturedType capturedType = (Type.CapturedType)undetVar.qtype;
                return new Type.CapturedType(capturedType.tsym.name, capturedType.tsym.owner, type, type2, capturedType.wildcard);
            }
        };

        final Type.UndetVar.InferenceBound ib;

        private InferenceStep(Type.UndetVar.InferenceBound inferenceBound) {
            this.ib = inferenceBound;
        }

        abstract Type solve(Type.UndetVar var1, InferenceContext var2);

        public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
            return this.filterBounds(undetVar, inferenceContext).nonEmpty() && !undetVar.isCaptured();
        }

        List<Type> filterBounds(Type.UndetVar undetVar, InferenceContext inferenceContext) {
            return Type.filter(undetVar.getBounds(this.ib), new BoundFilter(inferenceContext));
        }
    }

    abstract class BestLeafSolver
    extends LeafSolver {
        List<Type> varsToSolve;
        final Map<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>> treeCache;
        final Pair<List<GraphSolver.InferenceGraph.Node>, Integer> noPath;

        BestLeafSolver(List<Type> list) {
            this.treeCache = new HashMap<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>>();
            this.noPath = new Pair<Object, Integer>(null, Integer.MAX_VALUE);
            this.varsToSolve = list;
        }

        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> computeTreeToLeafs(GraphSolver.InferenceGraph.Node node) {
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair = this.treeCache.get(node);
            if (pair == null) {
                if (node.isLeaf()) {
                    pair = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(node), ((ListBuffer)node.data).length());
                } else {
                    Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair2 = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(node), ((ListBuffer)node.data).length());
                    for (GraphSolver.InferenceGraph.Node node2 : node.getAllDependencies()) {
                        if (node2 == node) continue;
                        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair3 = this.computeTreeToLeafs(node2);
                        pair2 = new Pair(((List)pair2.fst).prependList((List)pair3.fst), (Integer)pair2.snd + (Integer)pair3.snd);
                    }
                    pair = pair2;
                }
                this.treeCache.put(node, pair);
            }
            return pair;
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph inferenceGraph) {
            this.treeCache.clear();
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair = this.noPath;
            for (GraphSolver.InferenceGraph.Node node : inferenceGraph.nodes) {
                if (Collections.disjoint((Collection)node.data, this.varsToSolve)) continue;
                Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair2 = this.computeTreeToLeafs(node);
                if ((Integer)pair2.snd >= (Integer)pair.snd) continue;
                pair = pair2;
            }
            if (pair == this.noPath) {
                throw new GraphStrategy.NodeNotFoundException(inferenceGraph);
            }
            return (GraphSolver.InferenceGraph.Node)((List)pair.fst).head;
        }
    }

    abstract class LeafSolver
    implements GraphStrategy {
        LeafSolver() {
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph inferenceGraph) {
            if (inferenceGraph.nodes.isEmpty()) {
                throw new GraphStrategy.NodeNotFoundException(inferenceGraph);
            }
            return inferenceGraph.nodes.get(0);
        }
    }

    static interface GraphStrategy {
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph var1) throws NodeNotFoundException;

        public boolean done();

        public static class NodeNotFoundException
        extends RuntimeException {
            private static final long serialVersionUID = 0L;
            GraphSolver.InferenceGraph graph;

            public NodeNotFoundException(GraphSolver.InferenceGraph inferenceGraph) {
                this.graph = inferenceGraph;
            }
        }
    }

    protected static class BoundFilter
    implements Filter<Type> {
        InferenceContext inferenceContext;

        public BoundFilter(InferenceContext inferenceContext) {
            this.inferenceContext = inferenceContext;
        }

        @Override
        public boolean accepts(Type type) {
            return !type.isErroneous() && !this.inferenceContext.free(type) && !type.hasTag(TypeTag.BOT);
        }
    }

    class IncorporationBinaryOp {
        IncorporationBinaryOpKind opKind;
        Type op1;
        Type op2;

        IncorporationBinaryOp(IncorporationBinaryOpKind incorporationBinaryOpKind, Type type, Type type2) {
            this.opKind = incorporationBinaryOpKind;
            this.op1 = type;
            this.op2 = type2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IncorporationBinaryOp)) {
                return false;
            }
            IncorporationBinaryOp incorporationBinaryOp = (IncorporationBinaryOp)object;
            return this.opKind == incorporationBinaryOp.opKind && Infer.this.types.isSameType(this.op1, incorporationBinaryOp.op1, true) && Infer.this.types.isSameType(this.op2, incorporationBinaryOp.op2, true);
        }

        public int hashCode() {
            int n = this.opKind.hashCode();
            n *= 127;
            n += Infer.this.types.hashCode(this.op1);
            n *= 127;
            return n += Infer.this.types.hashCode(this.op2);
        }

        boolean apply(Warner warner) {
            return this.opKind.apply(this.op1, this.op2, warner, Infer.this.types);
        }
    }

    static enum IncorporationBinaryOpKind {
        IS_SUBTYPE{

            @Override
            boolean apply(Type type, Type type2, Warner warner, Types types) {
                return types.isSubtypeUnchecked(type, type2, warner);
            }
        }
        ,
        IS_SAME_TYPE{

            @Override
            boolean apply(Type type, Type type2, Warner warner, Types types) {
                return types.isSameType(type, type2);
            }
        };


        abstract boolean apply(Type var1, Type var2, Warner var3, Types var4);
    }

    abstract class AbstractIncorporationEngine
    implements Type.UndetVar.UndetVarListener {
        AbstractIncorporationEngine() {
        }

        @Override
        public void varInstantiated(Type.UndetVar undetVar) {
            undetVar.incorporationActions.addFirst(new SubstBounds(undetVar));
        }

        @Override
        public void varBoundChanged(Type.UndetVar undetVar, Type.UndetVar.InferenceBound inferenceBound, Type type, boolean bl) {
            if (undetVar.isCaptured()) {
                return;
            }
            undetVar.incorporationActions.addAll(this.getIncorporationActions(undetVar, inferenceBound, type, bl));
        }

        abstract List<IncorporationAction> getIncorporationActions(Type.UndetVar var1, Type.UndetVar.InferenceBound var2, Type var3, boolean var4);
    }

    class PropagateBounds
    extends IncorporationAction {
        Type.UndetVar.InferenceBound ib;

        public PropagateBounds(Type.UndetVar undetVar, Type type, Type.UndetVar.InferenceBound inferenceBound) {
            super(undetVar, type);
            this.ib = inferenceBound;
        }

        @Override
        public IncorporationAction dup(Type.UndetVar undetVar) {
            return new PropagateBounds(undetVar, this.t, this.ib);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warner) {
            Type type = inferenceContext.asUndetVar(this.t);
            if (type.hasTag(TypeTag.UNDETVAR) && !((Type.UndetVar)type).isCaptured()) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                undetVar.addBound(this.ib.complement(), this.uv, Infer.this.types);
                for (Type.UndetVar.InferenceBound inferenceBound : this.backwards()) {
                    for (Type type2 : undetVar.getBounds(inferenceBound)) {
                        this.uv.addBound(inferenceBound, type2, Infer.this.types);
                    }
                }
            }
            for (Type.UndetVar.InferenceBound inferenceBound : this.forward()) {
                for (Type type3 : this.uv.getBounds(inferenceBound)) {
                    Type type2;
                    type2 = inferenceContext.asUndetVar(type3);
                    if (!type2.hasTag(TypeTag.UNDETVAR) || ((Type.UndetVar)type2).isCaptured()) continue;
                    Type.UndetVar undetVar = (Type.UndetVar)type2;
                    undetVar.addBound(this.ib, inferenceContext.asInstType(this.t), Infer.this.types);
                }
            }
        }

        EnumSet<Type.UndetVar.InferenceBound> forward() {
            return this.ib == Type.UndetVar.InferenceBound.EQ ? EnumSet.of(Type.UndetVar.InferenceBound.EQ) : EnumSet.complementOf(EnumSet.of(this.ib));
        }

        EnumSet<Type.UndetVar.InferenceBound> backwards() {
            return this.ib == Type.UndetVar.InferenceBound.EQ ? EnumSet.allOf(Type.UndetVar.InferenceBound.class) : EnumSet.of(this.ib);
        }

        @Override
        public String toString() {
            return String.format("%s[undet=%s,t=%s,bound=%s]", new Object[]{this.getClass().getSimpleName(), this.uv.qtype, this.t, this.ib});
        }
    }

    class CheckUpperBounds
    extends IncorporationAction {
        public CheckUpperBounds(Type.UndetVar undetVar, Type type) {
            super(undetVar, type);
        }

        @Override
        public IncorporationAction dup(Type.UndetVar undetVar) {
            return new CheckUpperBounds(undetVar, this.t);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warner) {
            List<Type> list = this.uv.getBounds(Type.UndetVar.InferenceBound.UPPER).stream().collect(Infer.this.types.closureCollector(true, Infer.this.types::isSameType));
            for (Type type : list) {
                if (this.t == type || this.t == type || this.t.hasTag(TypeTag.WILDCARD) || type.hasTag(TypeTag.WILDCARD)) continue;
                for (Pair pair : Infer.this.getParameterizedSupers(this.t, type)) {
                    List<Type> list2 = ((Type)pair.fst).allparams();
                    List<Type> list3 = ((Type)pair.snd).allparams();
                    while (list2.nonEmpty() && list3.nonEmpty()) {
                        if (!(((Type)list2.head).hasTag(TypeTag.WILDCARD) || ((Type)list3.head).hasTag(TypeTag.WILDCARD) || this.isSameType(inferenceContext.asUndetVar((Type)list2.head), inferenceContext.asUndetVar((Type)list3.head)))) {
                            Infer.this.reportBoundError(this.uv, Type.UndetVar.InferenceBound.UPPER);
                        }
                        list2 = list2.tail;
                        list3 = list3.tail;
                    }
                    Assert.check(list2.isEmpty() && list3.isEmpty());
                }
            }
        }
    }

    class SubstBounds
    extends CheckInst {
        SubstBounds(Type.UndetVar undetVar) {
            super(undetVar, Type.UndetVar.InferenceBound.LOWER, Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.UPPER);
        }

        @Override
        public IncorporationAction dup(Type.UndetVar undetVar) {
            return new SubstBounds(undetVar);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warner) {
            for (Type type : inferenceContext.undetvars) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                undetVar.substBounds(List.of(this.uv.qtype), List.of(this.uv.getInst()), Infer.this.types);
                this.checkCompatibleUpperBounds(undetVar, inferenceContext);
            }
            super.apply(inferenceContext, warner);
        }

        void checkCompatibleUpperBounds(Type.UndetVar undetVar, InferenceContext inferenceContext) {
            List<Type> list = Type.filter(undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER), new BoundFilter(inferenceContext));
            Type type = list.isEmpty() ? Infer.this.syms.objectType : (list.tail.isEmpty() ? (Type)list.head : Infer.this.types.glb(list));
            if (type == null || type.isErroneous()) {
                Infer.this.reportBoundError(undetVar, Type.UndetVar.InferenceBound.UPPER);
            }
        }
    }

    class CheckInst
    extends CheckBounds {
        EnumSet<Type.UndetVar.InferenceBound> to;

        CheckInst(Type.UndetVar undetVar, Type.UndetVar.InferenceBound inferenceBound, Type.UndetVar.InferenceBound ... inferenceBoundArray) {
            this(undetVar, EnumSet.of(inferenceBound, inferenceBoundArray));
        }

        CheckInst(Type.UndetVar undetVar, EnumSet<Type.UndetVar.InferenceBound> enumSet) {
            super(undetVar, undetVar.getInst(), Type.UndetVar.InferenceBound.EQ);
            this.to = enumSet;
        }

        @Override
        public IncorporationAction dup(Type.UndetVar undetVar) {
            return new CheckInst(undetVar, this.to);
        }

        @Override
        EnumSet<Type.UndetVar.InferenceBound> boundsToCheck() {
            return this.to;
        }

        @Override
        void report(Type.UndetVar.InferenceBound inferenceBound, Type.UndetVar.InferenceBound inferenceBound2) {
            Infer.this.reportInstError(this.uv, inferenceBound2);
        }
    }

    class EqCheckLegacy
    extends CheckBounds {
        EqCheckLegacy(Type.UndetVar undetVar, Type type, Type.UndetVar.InferenceBound inferenceBound) {
            super(undetVar, type, InferenceContext::asInstType, InferenceContext::free, inferenceBound);
        }

        @Override
        public IncorporationAction dup(Type.UndetVar undetVar) {
            return new EqCheckLegacy(undetVar, this.t, this.from);
        }

        @Override
        EnumSet<Type.UndetVar.InferenceBound> boundsToCheck() {
            return this.from == Type.UndetVar.InferenceBound.EQ ? EnumSet.allOf(Type.UndetVar.InferenceBound.class) : EnumSet.of(Type.UndetVar.InferenceBound.EQ);
        }
    }

    class CheckBounds
    extends IncorporationAction {
        Type.UndetVar.InferenceBound from;
        BiFunction<InferenceContext, Type, Type> typeFunc;
        BiPredicate<InferenceContext, Type> optFilter;

        CheckBounds(Type.UndetVar undetVar, Type type, Type.UndetVar.InferenceBound inferenceBound) {
            this(undetVar, type, InferenceContext::asUndetVar, null, inferenceBound);
        }

        CheckBounds(Type.UndetVar undetVar, Type type, BiFunction<InferenceContext, Type, Type> biFunction, BiPredicate<InferenceContext, Type> biPredicate, Type.UndetVar.InferenceBound inferenceBound) {
            super(undetVar, type);
            this.from = inferenceBound;
            this.typeFunc = biFunction;
            this.optFilter = biPredicate;
        }

        @Override
        public IncorporationAction dup(Type.UndetVar undetVar) {
            return new CheckBounds(undetVar, this.t, this.typeFunc, this.optFilter, this.from);
        }

        @Override
        void apply(InferenceContext inferenceContext, Warner warner) {
            this.t = this.typeFunc.apply(inferenceContext, this.t);
            if (this.optFilter != null && this.optFilter.test(inferenceContext, this.t)) {
                return;
            }
            for (Type.UndetVar.InferenceBound inferenceBound : this.boundsToCheck()) {
                for (Type type : this.uv.getBounds(inferenceBound)) {
                    boolean bl;
                    type = this.typeFunc.apply(inferenceContext, type);
                    if (this.optFilter != null && this.optFilter.test(inferenceContext, type) || (bl = this.checkBound(this.t, type, this.from, inferenceBound, warner))) continue;
                    this.report(this.from, inferenceBound);
                }
            }
        }

        EnumSet<Type.UndetVar.InferenceBound> boundsToCheck() {
            return this.from == Type.UndetVar.InferenceBound.EQ ? EnumSet.allOf(Type.UndetVar.InferenceBound.class) : EnumSet.complementOf(EnumSet.of(this.from));
        }

        boolean checkBound(Type type, Type type2, Type.UndetVar.InferenceBound inferenceBound, Type.UndetVar.InferenceBound inferenceBound2, Warner warner) {
            if (inferenceBound.lessThan(inferenceBound2)) {
                return this.isSubtype(type, type2, warner);
            }
            if (inferenceBound2.lessThan(inferenceBound)) {
                return this.isSubtype(type2, type, warner);
            }
            return this.isSameType(type, type2);
        }

        void report(Type.UndetVar.InferenceBound inferenceBound, Type.UndetVar.InferenceBound inferenceBound2) {
            if (inferenceBound == inferenceBound2) {
                Infer.this.reportBoundError(this.uv, inferenceBound);
            } else if (inferenceBound == Type.UndetVar.InferenceBound.LOWER || inferenceBound2 == Type.UndetVar.InferenceBound.EQ) {
                Infer.this.reportBoundError(this.uv, inferenceBound2, inferenceBound);
            } else {
                Infer.this.reportBoundError(this.uv, inferenceBound, inferenceBound2);
            }
        }

        @Override
        public String toString() {
            return String.format("%s[undet=%s,t=%s,bound=%s]", new Object[]{this.getClass().getSimpleName(), this.uv.qtype, this.t, this.from});
        }
    }

    public abstract class IncorporationAction {
        Type.UndetVar uv;
        Type t;

        IncorporationAction(Type.UndetVar undetVar, Type type) {
            this.uv = undetVar;
            this.t = type;
        }

        public abstract IncorporationAction dup(Type.UndetVar var1);

        abstract void apply(InferenceContext var1, Warner var2);

        boolean isSubtype(Type type, Type type2, Warner warner) {
            return Infer.this.doIncorporationOp(IncorporationBinaryOpKind.IS_SUBTYPE, type, type2, warner);
        }

        boolean isSameType(Type type, Type type2) {
            return Infer.this.doIncorporationOp(IncorporationBinaryOpKind.IS_SAME_TYPE, type, type2, null);
        }

        public String toString() {
            return String.format("%s[undet=%s,t=%s]", this.getClass().getSimpleName(), this.uv.qtype, this.t);
        }
    }

    class ImplicitArgType
    extends DeferredAttr.DeferredTypeMap {
        public ImplicitArgType(Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            DeferredAttr deferredAttr = Infer.this.rs.deferredAttr;
            deferredAttr.getClass();
            super(deferredAttr, DeferredAttr.AttrMode.SPECULATIVE, symbol, methodResolutionPhase);
        }

        @Override
        public Type visitClassType(Type.ClassType classType, Void void_) {
            return Infer.this.types.erasure(classType);
        }

        @Override
        public Type visitType(Type type, Void void_) {
            if (type.hasTag(TypeTag.DEFERRED)) {
                return this.visit(super.visitType(type, null));
            }
            if (type.hasTag(TypeTag.BOT)) {
                type = Infer.this.types.boxedClass((Type)Infer.this.syms.voidType).type;
            }
            return type;
        }
    }

    public class PartiallyInferredMethodType
    extends Type.MethodType {
        final InferenceContext inferenceContext;
        Env<AttrContext> env;
        final Warner warn;

        public PartiallyInferredMethodType(Type.MethodType methodType, InferenceContext inferenceContext, Env<AttrContext> env, Warner warner) {
            super((List<Type>)methodType.getParameterTypes(), methodType.getReturnType(), (List<Type>)methodType.getThrownTypes(), methodType.tsym);
            this.inferenceContext = inferenceContext;
            this.env = env;
            this.warn = warner;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type check(Attr.ResultInfo resultInfo) {
            Warner warner = new Warner(null);
            Infer.this.inferenceException.clear();
            List<Type> list = null;
            try {
                Object object;
                list = this.inferenceContext.save();
                boolean bl = this.warn.hasNonSilentLint(Lint.LintCategory.UNCHECKED);
                if (!bl) {
                    boolean bl2 = Infer.this.shouldPropagate(this.getReturnType(), resultInfo, this.inferenceContext);
                    object = bl2 ? this.inferenceContext.min(Infer.this.roots(this.asMethodType(), null), false, this.warn) : this.inferenceContext;
                    Type.MethodType methodType = (Type.MethodType)((InferenceContext)object).update(this.asMethodType());
                    Type type = Infer.this.generateReturnConstraints(this.env.tree, resultInfo, methodType, (InferenceContext)object);
                    if (bl2) {
                        ((InferenceContext)object).dupTo(resultInfo.checkContext.inferenceContext(), resultInfo.checkContext.deferredAttrContext().insideOverloadPhase());
                        Type type2 = type;
                        return type2;
                    }
                }
                this.inferenceContext.solve(warner);
                Type type = this.inferenceContext.asInstType(this).getReturnType();
                if (bl) {
                    type = Infer.this.types.erasure(type);
                }
                object = resultInfo.check(this.env.tree, type);
                return object;
            }
            catch (InferenceException inferenceException) {
                resultInfo.checkContext.report(null, inferenceException.getDiagnostic());
                Assert.error();
                Type type = null;
                return type;
            }
            finally {
                if (list != null) {
                    this.inferenceContext.rollback(list);
                }
            }
        }
    }

    public static class InferenceException
    extends Resolve.InapplicableMethodException {
        private static final long serialVersionUID = 0L;
        List<JCDiagnostic> messages = List.nil();

        InferenceException(JCDiagnostic.Factory factory) {
            super(factory);
        }

        @Override
        Resolve.InapplicableMethodException setMessage() {
            return this;
        }

        @Override
        Resolve.InapplicableMethodException setMessage(JCDiagnostic jCDiagnostic) {
            this.messages = this.messages.append(jCDiagnostic);
            return this;
        }

        @Override
        public JCDiagnostic getDiagnostic() {
            return (JCDiagnostic)this.messages.head;
        }

        void clear() {
            this.messages = List.nil();
        }
    }
}

