/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class DoubleElement
extends AtomicElement<Double> {
    private final double _value;

    DoubleElement(Element parent, Element prev, double d) {
        super(parent, prev);
        this._value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 8 : 9;
    }

    @Override
    public Double getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.DOUBLE;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size = this.size();
        if (b.remaining() >= size) {
            if (size == 9) {
                b.put((byte)-126);
            }
            b.putDouble(this._value);
            return size;
        }
        return 0;
    }
}

