#include <forms.h>
#include "load_data.h"
#include "main_window.h"

extern BS_data_list data;  
extern FD_main_window *main_window;

void 
list_data(int anzahl)
{
  FL_OBJECT *ob;
  long parameter;

  BS_data_list first_entry;
  char entry_line[6000];
  char nix[5];
  int irun,choice;

  first_entry=data;

  fl_clear_browser(main_window->list);
  fl_set_browser_fontstyle(main_window->list,4);
  strcpy(nix," | ");

  choice=fl_get_choice(main_window->list_column_choice);

  fl_freeze_form(main_window->main_window);
  if(anzahl==0)
    {
      /* list all data */
      do
	{
	  memset(entry_line,' ',6000);
	  memmove(entry_line,
		  data->field_text[2],
		  MIN(26,strlen(data->field_text[2])));
	  memmove(entry_line+26,
		  nix,
		  3);
	  memmove(entry_line+29,
		  data->field_text[choice],
		  strlen(data->field_text[choice]));
	  memmove(entry_line+80,
		  nix,
		  3);
	  memmove(entry_line+83,
		  data->field_text[22]
		  ,4);
	  memset(entry_line+87,0,1);
	  while(strstr(entry_line,"\n"))
	    *(strstr(entry_line,"\n"))=' ';
	  fl_addto_browser(main_window->list,entry_line);
	  data->visible=1;
	  data=data->next_entry;
	} while(data != first_entry);
    }
  else
    {
      irun=-1;
      do{
	if(data->visible==1)
	  {
	    memset(entry_line,' ',200);
	    memmove(entry_line,
		    data->field_text[2],
		    MIN(26,strlen(data->field_text[2])));
	    memmove(entry_line+26,
		    nix,
		    3);
	    memmove(entry_line+29,
		    data->field_text[choice],
		  strlen(data->field_text[choice]));
	    memmove(entry_line+80,
		    nix,
		    3);
	    memmove(entry_line+83,
		    data->field_text[22]
		    ,4);
	    memset(entry_line+87,0,1);
	    while(strstr(entry_line,"\n"))
	      *(strstr(entry_line,"\n"))=' ';
	    fl_addto_browser(main_window->list,entry_line);
	  }
	  data=data->next_entry;
	} while(data != first_entry);
    }
  fl_set_browser_topline(main_window->list,1);
  fl_unfreeze_form(main_window->main_window);
  data=first_entry;
}

void
list_data_all()
{
  list_data(0);
}

void
cb_list_column_choice(FL_OBJECT *ob,long button)
{
  list_data(fl_get_browser_maxline(main_window->list));
}

void 
list_data_selected()
{
  BS_data_list 
    first_entry,
    first_selected,
    first_not_selected,
    is_selected,is_not_selected;

  int irun,selected,not_selected,list_entries;

  list_entries=fl_get_browser_maxline(main_window->list);
  
  first_entry=data;
  irun=selected=not_selected=0;
  do
    {
      if(irun++<list_entries &&
	 fl_isselected_browser_line(main_window->list,irun) != 0)
	{  
	  data->visible=1;
	  if(++selected == 1)
	    first_selected=is_selected=data;
	  else
	    {
	      is_selected->next_entry=data;
	      is_selected=data;
	    }
	}
      else
	{  
	  data->visible=0;
	  if(++not_selected == 1)
	    {
	      first_not_selected=is_not_selected=data;
	    }
	  else
	    {
	      is_not_selected->next_entry=data;
	      is_not_selected=data;
	    }
	}
      data=data->next_entry;
    }while(data != first_entry); 
  
  if(selected > 0 )
    {
      if(not_selected > 0 )
	{
	  is_selected->next_entry=first_not_selected;
	  is_not_selected->next_entry=first_selected;
	}
      else
	is_selected->next_entry=first_selected;
      
      data=first_selected;
      list_data(selected);
    }
  else
    {
      data=first_entry;
      list_data(0);
    }
}

void 
list_data_not_selected()
{
  BS_data_list 
    first_entry,
    first_not_selected,
    first_selected,
    is_not_selected,is_selected;

  int irun,not_selected,selected,list_entries;

  list_entries=fl_get_browser_maxline(main_window->list);
  first_entry=data;
  irun=not_selected=selected=0;
  do
    {
      if(irun++<list_entries &&
	 fl_isselected_browser_line(main_window->list,irun) == 0)
	{  
	  data->visible=1;
	  if(++not_selected == 1)
	    first_not_selected=is_not_selected=data;
	  else
	    {
	      is_not_selected->next_entry=data;
	      is_not_selected=data;
	    }
	}
      else
	{  
	  data->visible=0;
	  if(++selected == 1)
	    {
	      first_selected=is_selected=data;
	    }
	  else
	    {
	      is_selected->next_entry=data;
	      is_selected=data;
	    }
	}
      data=data->next_entry;
    }while(data != first_entry); 
  
  if(not_selected > 0 )
    {
      if(selected > 0 )
	{
	  is_not_selected->next_entry=first_selected;
	  is_selected->next_entry=first_not_selected;
	}
      else
	is_not_selected->next_entry=first_not_selected;
	  
      data=first_not_selected;
      list_data(not_selected);
    }
  else
    data=first_entry;
}










