/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2linit.c                                                    *
 * description: Initialisation of global variables.                           *
 *              In the end of this file you can (and should) add codes for    *
 *              further special WP characters!!!                              *
 ******************************************************************************/
#include <stdio.h>
#include "wp2latex.h"

int Wpd_check(void)
/* Check, whether the given document is a valid WP5.[01] document
 * --- return: ---
 * int Wpd_check() : 0 if OK, else error code
 */
{
  unsigned short id1, id2, std1, std2, filetype, dmp1, dmp2, dmp3;
  long Startdoc;

  Rd_word(wpd, &id1);
  Rd_word(wpd, &id2);
  Rd_word(wpd, &std1);
  Rd_word(wpd, &std2);
  Rd_word(wpd, &filetype);
  Rd_word(wpd, &dmp1);
  Rd_word(wpd, &dmp2);
  Rd_word(wpd, &dmp3);

  Startdoc = std2 * 65536L + std1;

  if (id1 == 0x57ff && id2 == 0x4350 && filetype == 0xa01) {
      /* && dmp1 == 0 && dmp2 == 0 && dmp3 == 0 ) */
         /* ^-- this was a comment in the Pascal file. I (AT) translated
          * this code into C by hand, because it seems me to give a hint
          * on the WP-Version. I'm absolutely not sure whether the
          * following is correct, but I think:
          *   dmp1 == 0x0000 -> WP 5.0
          *   dmp1 == 0x0100 -> WP 5.1
          *   dmp1 == 0x0002 -> WP 6.0  <- this will not correct handled!!!!
          */
     fseek(wpd, Startdoc * sizeof(uchar), SEEK_SET);
     if ( dmp1 == 2 ) {
        fputs("\n\nWarning: It seems to be a WordPerfect 6.0 document!", stderr);
        fputs("\nEXPECT ERRORS!!!\n\n", stderr);
     }
  } else {
    fprintf(stderr, "Not a WordPerfect 5.1 document !\n");
    return 0x201;   /* no WP5.[01]-document */
  }
  return 0;
  /* it is a valid WP5.[01]-document*/
}

void Init_commando(void)
{
  open_com[0]    = "{\\LARGE ";
  open_com[0x1]  = "{\\Large ";
  open_com[0x2]  = "{\\large ";
  open_com[0x3]  = "{\\small ";
  open_com[0x4]  = "{\\footnotesize ";
  open_com[0x5]  = "$^{\\rm ";
  open_com[0x6]  = "$_{\\rm ";
  open_com[0x7]  = "{\\tt ";     /* MC: Render "outline" as \tt */
  open_com[0x8]  = "{\\it ";
  open_com[0x9]  = "";
  open_com[0xa]  = "";
  open_com[0xb]  = "\\underline{\\Underline{";
  open_com[0xc]  = "{\\bf ";
  open_com[0xd]  = "";
  open_com[0xe]  = "\\Underline{";
  open_com[0xf]  = "{\\sc ";

  close_com[0]   = "}";
  close_com[0x1] = "}";
  close_com[0x2] = "}";
  close_com[0x3] = "}";
  close_com[0x4] = "}";
  close_com[0x5] = "}$";
  close_com[0x6] = "}$";
  close_com[0x7] = "}";  /* MC; see above */
  close_com[0x8] = "\\/}";
  close_com[0x9] = "";
  close_com[0xa] = "";
  close_com[0xb] = "}}";
  close_com[0xc] = "}";
  close_com[0xd] = "";
  close_com[0xe] = "}";
  close_com[0xf] = "}";
}

void WP_Default(struct LOC_Convert_first_pass *LINK)
{
  short j;

  LINK->WP_sidemargin = 1200;

  LINK->tabpos[0] = 0x2c5;   /* 1e WP-tab is kantlijn --> */
  for (j = 2; j <= 10; j++)   /* Volgende tabs 1,5  cm     */
    LINK->tabpos[j - 1] = LINK->tabpos[j - 2] + 0x2c5;
  for (j = 10; j <= 39; j++)   /* ($02c5 wpu) verder        */
    LINK->tabpos[j] = 0xffffL;

  LINK->num_of_tabs = 10;
}

void Table_Init(struct LOC_Convert_first_pass *LINK)
{
  LINK->lat[0x00] = " ";     /*Space*/
  LINK->lat[0x01] = "!";     /*!*/
  LINK->lat[0x02] = "\"";    /*"*/
  LINK->lat[0x03] = "\\#";   /*#*/
  LINK->lat[0x04] = "\\$";   /*dollar*/
  LINK->lat[0x05] = "\\%";   /*%*/
  LINK->lat[0x06] = "\\&";   /*&*/
  LINK->lat[0x07] = "'";     /*'*/
  LINK->lat[0x08] = "(";     /*(*/
  LINK->lat[0x09] = ")";     /*)*/
  LINK->lat[0x0a] = "*";     /***/
  LINK->lat[0x0b] = "+";     /*+*/
  LINK->lat[0x0c] = ",";     /*,*/
  LINK->lat[0x0d] = "-";     /*-*/
  LINK->lat[0x0e] = ".";     /*.*/
  LINK->lat[0x0f] = "/";     /* / */
  LINK->lat[0x10] = "0";     /*0*/
  LINK->lat[0x11] = "1";     /*1*/
  LINK->lat[0x12] = "2";     /*2*/
  LINK->lat[0x13] = "3";     /*3*/
  LINK->lat[0x14] = "4";     /*4*/
  LINK->lat[0x15] = "5";     /*5*/
  LINK->lat[0x16] = "6";     /*6*/
  LINK->lat[0x17] = "7";     /*7*/
  LINK->lat[0x18] = "8";     /*8*/
  LINK->lat[0x19] = "9";     /*9*/
  LINK->lat[0x1a] = ":";     /*:*/
  LINK->lat[0x1b] = ";";     /*;*/
  LINK->lat[0x1c] = "$<$";   /*<*/
  LINK->lat[0x1d] = "=";     /*=*/
  LINK->lat[0x1e] = "$>$";   /*>*/
  LINK->lat[0x1f] = "?";     /*?*/
  LINK->lat[0x20] = "@";     /*@*/
  LINK->lat[0x21] = "A";     /*A*/
  LINK->lat[0x22] = "B";     /*B*/
  LINK->lat[0x23] = "C";     /*C*/
  LINK->lat[0x24] = "D";     /*D*/
  LINK->lat[0x25] = "E";     /*E*/
  LINK->lat[0x26] = "F";     /*F*/
  LINK->lat[0x27] = "G";     /*G*/
  LINK->lat[0x28] = "H";     /*H*/
  LINK->lat[0x29] = "I";     /*I*/
  LINK->lat[0x2a] = "J";     /*J*/
  LINK->lat[0x2b] = "K";     /*K*/
  LINK->lat[0x2c] = "L";     /*L*/
  LINK->lat[0x2d] = "M";     /*M*/
  LINK->lat[0x2e] = "N";     /*N*/
  LINK->lat[0x2f] = "O";     /*O*/
  LINK->lat[0x30] = "P";     /*P*/
  LINK->lat[0x31] = "Q";     /*Q*/
  LINK->lat[0x32] = "R";     /*R*/
  LINK->lat[0x33] = "S";     /*S*/
  LINK->lat[0x34] = "T";     /*T*/
  LINK->lat[0x35] = "U";     /*U*/
  LINK->lat[0x36] = "V";     /*V*/
  LINK->lat[0x37] = "W";     /*W*/
  LINK->lat[0x38] = "X";     /*X*/
  LINK->lat[0x39] = "Y";     /*Y*/
  LINK->lat[0x3a] = "Z";     /*Z*/
  LINK->lat[0x3b] = "[";     /*[*/
  LINK->lat[0x3c] = "$\\tt\\backslash$";   /*\*/
  LINK->lat[0x3d] = "]";     /*]*/
  LINK->lat[0x3e] = "\\^{";  /*^*/
  LINK->lat[0x3f] = "\\_";   /*_*/
  LINK->lat[0x40] = "`";     /*`*/
  LINK->lat[0x41] = "a";     /*a*/
  LINK->lat[0x42] = "b";     /*b*/
  LINK->lat[0x43] = "c";     /*c*/
  LINK->lat[0x44] = "d";     /*d*/
  LINK->lat[0x45] = "e";     /*e*/
  LINK->lat[0x46] = "f";     /*f*/
  LINK->lat[0x47] = "g";     /*g*/
  LINK->lat[0x48] = "h";     /*h*/
  LINK->lat[0x49] = "i";     /*i*/
  LINK->lat[0x4a] = "j";     /*j*/
  LINK->lat[0x4b] = "k";     /*k*/
  LINK->lat[0x4c] = "l";     /*l*/
  LINK->lat[0x4d] = "m";     /*m*/
  LINK->lat[0x4e] = "n";     /*n*/
  LINK->lat[0x4f] = "o";     /*o*/
  LINK->lat[0x50] = "p";     /*p*/
  LINK->lat[0x51] = "q";     /*q*/
  LINK->lat[0x52] = "r";     /*r*/
  LINK->lat[0x53] = "s";     /*s*/
  LINK->lat[0x54] = "t";     /*t*/
  LINK->lat[0x55] = "u";     /*u*/
  LINK->lat[0x56] = "v";     /*v*/
  LINK->lat[0x57] = "w";     /*w*/
  LINK->lat[0x58] = "x";     /*x*/
  LINK->lat[0x59] = "y";     /*y*/
  LINK->lat[0x5a] = "z";     /*z*/
  LINK->lat[0x5b] = "\\{";   /*{*/
  LINK->lat[0x5c] = "$|$";   /*|*/
  LINK->lat[0x5d] = "\\}";   /* */
  LINK->lat[0x5e] = "\\tilde{"; /*~*/
  LINK->lat[0x5f] = " ";     /*Doesn't exist*/
}

static void ToManyCharacters(void)
{
   fprintf(stderr, "To many special charcters defined. Increase MAXCHARNUM.\n");
   fprintf(stderr, "Further characters will be ignored.");
}

void Ext_chr_init(struct LOC_Convert_first_pass *LINK)
/* set conversion table for special WP characters */
{
#define WP_CHAR(set,code,str)  if ( ++wpcharnum > MAXCHARNUM ) { \
                                  ToManyCharacters(); return; } \
                               LINK->char_set[wpcharnum] = (set);  \
                               LINK->char_code[wpcharnum]  = (code); \
                               LINK->ext_lat[wpcharnum] = (str);
  int wpcharnum = -1;   /* counts special characters */

  WP_CHAR(0x1, 0x26, "\\c{C}");
  WP_CHAR(0x1, 0x47, "\\\"{u}");
  WP_CHAR(0x1, 0x29, "\\'{e}");
  WP_CHAR(0x1, 0x1d, "\\^{a}");
  WP_CHAR(0x1, 0x1f, "\\\"{a}");
  WP_CHAR(0x1, 0x21, "\\`{a}");
  WP_CHAR(0x1, 0x23, "\\aa ");
  WP_CHAR(0x1, 0x27, "\\c{c}");
  WP_CHAR(0x1, 0x2b, "\\^{e}");
  WP_CHAR(0x1, 0x2d, "\\\"{e}");
  WP_CHAR(0x1, 0x2f, "\\`{e}");
  WP_CHAR(0x1, 0x35, "\\\"{\\i}");
  WP_CHAR(0x1, 0x33, "\\^{\\i}");
  WP_CHAR(0x1, 0x37, "\\`{\\i}");
  WP_CHAR(0x1, 0x1e, "\\\"{A}");
  WP_CHAR(0x1, 0x22, "\\AA ");
  WP_CHAR(0x1, 0x28, "\\'{E}");
  WP_CHAR(0x1, 0x25, "\\ae ");
  WP_CHAR(0x1, 0x24, "\\AE ");
  WP_CHAR(0x1, 0x3d, "\\^{o}");
  WP_CHAR(0x1, 0x3f, "\\\"{o}");
  WP_CHAR(0x1, 0x41, "\\`{o}");
  WP_CHAR(0x1, 0x45, "\\^{u}");
  WP_CHAR(0x1, 0x49, "\\`{u}");
  WP_CHAR(0x1, 0x8b, "\\\"{y}");
  WP_CHAR(0x1, 0x3e, "\\\"{O}");
  WP_CHAR(0x1, 0x46, "\\\"{U}");
  WP_CHAR(0x4, 0x13, "\\ ");
  WP_CHAR(0x4, 0xb, "\\pounds ");
  WP_CHAR(0x4, 0xc, "\\ ");
  WP_CHAR(0x4, 0xd, "\\ ");
  WP_CHAR(0x4, 0xe, "{\\it f}\\/");
  WP_CHAR(0x1, 0x1b, "\\'{a}");
  WP_CHAR(0x1, 0x31, "\\'{\\i}");
  WP_CHAR(0x1, 0x3b, "\\'{o}");
  WP_CHAR(0x1, 0x43, "\\'{u}");
  WP_CHAR(0x1, 0x39, "\\~{n}");
  WP_CHAR(0x1, 0x38, "\\~{N}");
  WP_CHAR(0x4, 0xf, "\\astrike ");
  WP_CHAR(0x4, 0x10, "\\ostrike ");
  WP_CHAR(0x4, 0x8, "?`");
  WP_CHAR(0x5, 0x10, "~");
  WP_CHAR(0x6, 0x14, "~");
  WP_CHAR(0x4, 0x11, "$\\frac{1}{2}$");
  WP_CHAR(0x4, 0x12, "$\\frac{1}{4}$");
  WP_CHAR(0x4, 0x7, "!`");
  WP_CHAR(0x4, 0x9, "$\\ll$");
  WP_CHAR(0x4, 0xa, "$\\gg$");
  WP_CHAR(0x8, 0x1, "$\\alpha$");
  WP_CHAR(0x08, 0x03, "$\\beta$");
  WP_CHAR(0x8, 0x6, "$\\Gamma$");
  WP_CHAR(0x8, 0x21, "$\\pi$");
  WP_CHAR(0x8, 0x24, "$\\Sigma$");
  WP_CHAR(0x8, 0x25, "$\\sigma$");
  WP_CHAR(0x8, 0x19, "$\\mu$");
  WP_CHAR(0x8, 0x29, "$\\tau$");
  WP_CHAR(0x8, 0x2c, "$\\Phi$");
  WP_CHAR(0x8, 0x10, "$\\theta$");
  WP_CHAR(0x8, 0x32, "$\\Omega$");
  WP_CHAR(0x8, 0x9, "$\\delta$");
  WP_CHAR(0x6, 0x13, "$\\infty$");
  WP_CHAR(0x8, 0x2d, "$\\emptyset$");
  WP_CHAR(0x8, 0xb, "$\\epsilon$");
  WP_CHAR(0x6, 0x10, "$\\cap$");
  WP_CHAR(0x6, 0xe, "$\\equiv$");
  WP_CHAR(0x6, 0x1, "$\\pm$");
  WP_CHAR(0x6, 0x3, "$\\geq$");
  WP_CHAR(0x6, 0x2, "$\\leq$");
  WP_CHAR(0x7, 0, "~");
  WP_CHAR(0x7, 0x1, "~");
  WP_CHAR(0x6, 0x8, "$\\div$");
  WP_CHAR(0x6, 0xd, "$\\approx$");
  WP_CHAR(0x6, 0x24, "\\degrees ");
  WP_CHAR(0x6, 0x1f, "~");
  WP_CHAR(0x6, 0x20, "~");
  WP_CHAR(0x7, 0x4, "$\\surd$");
  WP_CHAR(0x4, 0x15, "$^{n}$");
  WP_CHAR(0x4, 0x14, "$^{2}$");
  WP_CHAR(0x4, 0x2, "~");
/*
** Note: Adding characters is easy. The maximum available is MAXCHARNUM = 256
** (increase the define statement in wp2latex.h if neccessary
** e.g. The Greek character set is char_set 0x8 (first argument of WP_CHAR),
** \Alpha has char_code 0x0, \alpha has char_code 0x1 ...
** \Omega has char_code 0x32 and \omega has char_code 0x33 (second argument).
** I suspect that there are two versions of some letters
** I've only added the ones I've needed for translating.
** Hence the apparent randomness.
*/
  WP_CHAR(0x8, 0x15, "$\\kappa$");
  WP_CHAR(0x8, 0x8, "$\\Delta$");
  WP_CHAR(0x8, 0xf, "$\\eta$");
  WP_CHAR(0x8, 0x27, "$\\zeta$");
  WP_CHAR(0x06, 0x0a, "$<$");
  WP_CHAR(0x06, 0x09, "$|$");
  WP_CHAR(0x8, 0x7, "$\\gamma$");
  WP_CHAR(0x8, 0x2b, "$\\phi$");
  WP_CHAR(0x6, 0x27, "$\\times$");
  WP_CHAR(0x6, 0x28, "$\\int$");
  WP_CHAR(0x8, 0x31, "$\\psi$");
  WP_CHAR(0x6, 0xb, "$>$");
  WP_CHAR(0x8, 0x2f, "$\\chi$");
  WP_CHAR(0x6, 0x17, "$\\uparrow$");
  WP_CHAR(0x6, 0x15, "$\\rightarrow$");
  WP_CHAR(0x8, 0x17, "$\\lambda$");
  WP_CHAR(0x8, 0x33, "$\\omega$");
  WP_CHAR(0x6, 0x2b, "$\\nabla$");

/* further charcters added by AT */
  WP_CHAR(0x1, 0x17, "\\ss{}"); /* sz */
  WP_CHAR(0x1, 0x62, "\\v{C}"); /*    */
  WP_CHAR(0x1, 0x63, "\\v{c}"); /*    */
  WP_CHAR(0x1, 0x6C, "\\.{E}"); /*    */
  WP_CHAR(0x1, 0x6D, "\\.{e}"); /*    */
  WP_CHAR(0x1, 0xB0, "\\v{S}"); /*    */
  WP_CHAR(0x1, 0xB1, "\\v{s}"); /*    */
  WP_CHAR(0x1, 0xCE, "\\v{Z}"); /*    */
  WP_CHAR(0x1, 0xCF, "\\v{z}"); /*    */
/*    */
#undef WP_CHAR
}

