use alloc::collections::BinaryHeap;
use core::cmp::Ord;

pub(crate) fn k_smallest<T: Ord, I: Iterator<Item = T>>(mut iter: I, k: usize) -> BinaryHeap<T> {
    if k == 0 { return BinaryHeap::new(); }

    let mut heap = iter.by_ref().take(k).collect::<BinaryHeap<_>>();

    iter.for_each(|i| {
        debug_assert_eq!(heap.len(), k);
        
        
        
        if *heap.peek().unwrap() > i {
            *heap.peek_mut().unwrap() = i;
        }
    });

    heap
}
