% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_categorical.R
\name{as_categorical.decorated}
\alias{as_categorical.decorated}
\title{Coerce decorated to Categorical}
\usage{
\method{as_categorical}{decorated}(x, ...)
}
\arguments{
\item{x}{decorated}

\item{...}{unquoted names of columns to be converted}
}
\value{
decorated
}
\description{
Coerces (elements of) 'decorated' to categorical.  See example(s).
Briefly, a continuous variable with units (and a small set of existing values)
is converted to a factor-ready variable.
}
\examples{
library(magrittr)
library(tablet)
library(kableExtra)
library(yamlet)
x <- data.frame(DOSE = c(12, 1.2, 2.4, 6, 12, 1.2)) \%>\% decorate('DOSE: [ Dose, mg ]')
x \%>\% 
  as_categorical(DOSE) \%>\%
  resolve \%>\% 
  tablet \%>\% 
  as_kable \%>\%
  kable_classic
  
}
\seealso{
Other decorated: 
\code{\link{[.decorated}()},
\code{\link{[<-.decorated}()},
\code{\link{[[.decorated}()},
\code{\link{[[<-.decorated}()},
\code{\link{as_categorical}()},
\code{\link{merge.decorated}()},
\code{\link{names<-.decorated}()}
}
\concept{decorated}
\keyword{manip}
