% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vpc_input_data.R
\name{format_vpc_input_data}
\alias{format_vpc_input_data}
\alias{format_vpc_input_data_tte}
\title{Prepare VPC data for future calculations by standardizing column names and
modifying the input data based on the limits of quantification,
stratification, and logarithmic values.}
\usage{
format_vpc_input_data(
  dat,
  cols,
  lloq,
  uloq,
  stratify,
  log_y,
  log_y_min,
  what = "observed",
  verbose = FALSE,
  pred_corr = FALSE
)

format_vpc_input_data_tte(
  dat,
  cols,
  stratify,
  rtte,
  rtte_calc_diff,
  what = "observed",
  verbose = FALSE
)
}
\arguments{
\item{dat}{An input data.frame or similar object}

\item{cols}{A list with an element for colname giving the name for colname in
\code{dat}.}

\item{lloq}{Number or NULL indicating lower limit of quantification. Default is NULL.}

\item{uloq}{Number or NULL indicating upper limit of quantification. Default is NULL.}

\item{stratify}{character vector of stratification variables. Only 1 or 2 stratification variables can be supplied.}

\item{log_y}{Boolean indicting whether y-axis should be shown as logarithmic. Default is FALSE.}

\item{log_y_min}{minimal value when using log_y argument. Default is 1e-3.}

\item{what}{The description of the data (typically "observed" or "simulated")}

\item{verbose}{show debugging information (TRUE or FALSE)}

\item{pred_corr}{perform prediction-correction?}

\item{rtte}{repeated time-to-event data? Default is FALSE (treat as
single-event TTE)}

\item{rtte_calc_diff}{recalculate time (T/F)? When simulating in NONMEM, you
will probably need to set this to TRUE to recalculate the TIME to relative
times between events (unless you output the time difference between events
and specify that as independent variable to the vpc_tte() function.}
}
\value{
\code{dat} modified based on other inputs.

A named list with "dat" modified, as required, and "stratify" with
  the stratification parameters
}
\description{
Prepare VPC data for future calculations by standardizing column names and
modifying the input data based on the limits of quantification,
stratification, and logarithmic values.
}
\section{Functions}{
\itemize{
\item \code{format_vpc_input_data_tte()}: Prepare VPC data for future calculations
for time-to-event data

}}
