% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_save.R
\name{tt_save}
\alias{tt_save}
\title{Save a typst_table to SVG, PNG, PDF, or Typst source}
\usage{
tt_save(
  table,
  file,
  width = "auto",
  height = "auto",
  margin = "0.5em",
  ppi = 144,
  typst_path = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{table}{A \code{typst_table} object created with \code{tt()}.}

\item{file}{Output file path. The format is determined by the file extension:
\code{.svg}, \code{.png}, \code{.pdf}, or \code{.typ} (Typst source).}

\item{width}{Page width. Use \code{"auto"} (default) for automatic sizing based on
table content, or specify a Typst length like \code{"6in"}, \code{"15cm"}, \code{"400pt"}.}

\item{height}{Page height. Use \code{"auto"} (default) for automatic sizing, or
specify a Typst length.}

\item{margin}{Page margin around the table. Default is \code{"0.5em"}. Use \code{"0pt"}
for no margin.}

\item{ppi}{Pixels per inch for PNG output. Default is 144. Higher values
produce larger, higher-resolution images.}

\item{typst_path}{Path to the Typst executable. If \code{NULL} (default), searches
for \code{typst} on the system PATH.}

\item{overwrite}{Logical. If \code{TRUE} (default), overwrites existing files.
If \code{FALSE}, throws an error when the output file already exists.}
}
\value{
Invisibly returns the output file path.
}
\description{
Exports a \code{typst_table} object to various output formats. For SVG, PNG, and PDF
output, the Typst CLI must be installed and available on the system PATH.
}
\details{
For \code{.typ} output, only the Typst source code is written and the Typst CLI
is not required.

For \code{.svg}, \code{.png}, and \code{.pdf} output, the function:
1
\enumerate{
\item Generates a complete Typst document with appropriate page settings
\item Writes it to a temporary \code{.typ} file
\item Calls \verb{typst compile} to render the output
\item Cleans up the temporary file
}

The \code{width} and \code{height} parameters control the page size. Using \code{"auto"}
for both (the default
for both (the default) creates a page that fits the table content exactly.
}
\examples{
# Save Typst source (no CLI required)
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_save(file.path(tempdir(), "table.typ"))

if (tt_typst_available()) {
  # Save as SVG
  tt(mtcars[1:5, 1:3], rownames = FALSE) |>
    tt_save(file.path(tempdir(), "table.svg"))

  # Save as PNG with higher resolution
  tt(mtcars[1:5, 1:3], rownames = FALSE) |>
    tt_save(file.path(tempdir(), "table.png"), ppi = 300)

  # Save as PDF with specific page size
  tt(mtcars[1:5, 1:3], rownames = FALSE) |>
    tt_style(stroke = TRUE) |>
    tt_save(file.path(tempdir(), "table.pdf"), width = "6in", height = "4in")
}

}
