% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_daily_mstl.R
\name{sim_daily_mstl}
\alias{sim_daily_mstl}
\title{Daily time series simulation for the MSTL-algorithm}
\usage{
sim_daily_mstl(
  N,
  multiplicative = TRUE,
  start = 2020,
  sizeAnnualSeas = 100,
  sizeWeeklySeas = 100,
  sizeIrregularity = 100,
  shockAnnualSeas = 1,
  shockWeeklySeas = 1,
  deterministic = FALSE
)
}
\arguments{
\item{N}{length in years}

\item{multiplicative}{If TRUE, a multiplicative model is simulated, if FALSE, the model is additive}

\item{start}{Start year or start date of the simulation.}

\item{sizeAnnualSeas}{Size of the annual seasonal factor, defaulted to 100.}

\item{sizeWeeklySeas}{Size of the weekly seasonal factor, defaulted to 100.}

\item{sizeIrregularity}{Size of the irregular component, defaulted to 100.}

\item{shockAnnualSeas}{Shock to the annual seasonal coefficient, defaulted to 1.}

\item{shockWeeklySeas}{Shock to the weekly seasonal coefficient, defaulted to 1.}

\item{deterministic}{If TRUE, the seasonal coefficients are deterministic, meaning they do not change after a seasonal cycle. If FALSE, the coefficients are stochastic, meaning they change randomly after a seasonal cycle.}
}
\value{
Multiple simulated daily time series of class xts including:
\describe{
\item{original}{The original series}
\item{seas_adj}{The original series without seasonal effects}
\item{sfac7}{The day-of-the-week effect}
\item{sfac365}{The day-of-the-year effect}
}
}
\description{
This function simulates a daily time series according to the simulation model of
Bandara, Hyndman and Bergmeir (2021) about the MSTL-algorithm for seasonal-trend decomposition.
The simulated time series consists of a trend, weekly, annual and irregular component which are
each simulated independently from each other. After the simulation process they are normalized and then combined
to form the complete time series. As in the paper, this simulation function has the option to distinguish between
a deterministic and a stochastic data generation process.
}
\examples{
x <- sim_daily_mstl(4)
ts.plot(x[,1])
}
\references{
Bandara, K., Hyndman, R. J., & Bergmeir, C. (2021). MSTL: A seasonal-trend decomposition
algorithm for time series with multiple seasonal patterns. arXiv preprint arXiv:2107.13462.
}
\author{
Nikolas Fritz, Daniel Ollech
}
