% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_class.R
\name{validate_class}
\alias{validate_class}
\title{Validate Class}
\usage{
validate_class(
  input,
  class_type = c("numeric", "integer", "logical", "character", "factor", "complex",
    "raw", "date", "date-time", "hms"),
  logic = c("or", "and"),
  type = c("error", "warning", "message"),
  na_ok = TRUE,
  null_ok = TRUE,
  finite = FALSE,
  var_name = NULL,
  calls = NULL
)
}
\arguments{
\item{input}{The data to be validated.}

\item{class_type}{A vector of class types to check. Possible values are
"numeric", "integer", "logical", "character", "factor", "complex", "raw",
"date", "date-time", "hms".}

\item{logic}{The logical operator to use when combining checks. Possible
values are "or", and "and".}

\item{type}{A character string specifying the type of message to be displayed
if the input is not numeric or if the values are out of range. Must be one
of "error", "warning", or "message".}

\item{na_ok}{Logical. If TRUE, NA values are allowed. Default is TRUE.}

\item{null_ok}{Logical. If TRUE, NULL values are allowed. Default is TRUE.}

\item{finite}{Logical. If TRUE, only finite values are allowed. Default is
FALSE.}

\item{var_name}{Optional. A character string giving the desired variable (or
object) name that will appear in console output in place of the how the
object will typically be named in messages via deparse(substitute(input)).}

\item{calls}{Optional. The number of callers to go back in the call stack for
error messaging. If NULL, will default to 2.}
}
\value{
NULL. The function is used for its side effects.
}
\description{
This function checks if the input is of the specified class type(s).
Depending on the specified type, it will either throw an error, issue a
warning, or send a message. It also checks for NULL and NA values based on
the specified parameters.
}
\author{
Nicolas Foss, Ed.D., MS
}
