% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convolution.R
\name{convolution}
\alias{convolution}
\alias{convolution.default}
\alias{convolution.units}
\alias{convolution.transfR}
\title{Convolution of net rainfall with unit hydrograph}
\usage{
convolution(Rn, ...)

\method{convolution}{default}(Rn, uh, continuous = FALSE, ...)

\method{convolution}{units}(Rn, uh, ...)

\method{convolution}{transfR}(
  Rn,
  Rcol = "RnSim",
  Qcol = "Qsim",
  save_donor = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{Rn}{net rainfall vector or an object of class \code{transfR}}

\item{...}{further arguments passed to or from other methods}

\item{uh}{unit hydrograph vector}

\item{continuous}{boolean indicating if, when one time step might be influenced by past or future rainfall
(according to the time span of the unit hydrograph), no simulated value is provided}

\item{Rcol}{name of the space-time attribute for the discharge simulation in the \code{transfR} object}

\item{Qcol}{name of the space-time attribute for the net rainfall in the \code{transfR} object}

\item{save_donor}{boolean indicating if additional discharge simulations should be computed using the
net rainfall of each individual donor catchment instead of just the weighted average net rainfall. This
requires that \code{save_donor} was TRUE when using \link{mixr}}

\item{verbose}{boolean indicating if information messages should be written to the console}
}
\value{
An object of the same class of \code{Rn}. If \code{Rn} is a transfR object,
the same transfR object incremented by the new computed attributes.
}
\description{
Simulate the discharge by a convolution between the unit hydrograph and the net rainfall.
}
\examples{
data(Oudon)
icatch <- 1
uc <- velocity(hl = Oudon$hl[[icatch]])
uh <- uh(hl = Oudon$hl[[icatch]], uc = uc, deltat = units::set_units(1,"h"))$prob
Rn <- units::set_units(c(1,5,2), "mm/h")
Qsim <- convolution(Rn = Rn, uh = uh)
}
