% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_png.R
\name{optim_png}
\alias{optim_png}
\title{Optimize PNG images}
\usage{
optim_png(
  input,
  output = identity,
  level = 2L,
  alpha = FALSE,
  preserve = TRUE,
  recursive = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{input}{Path to the input PNG file or directory. If a directory is provided,
all PNG files in the directory (and subdirectories if \code{recursive = TRUE})
will be optimized.}

\item{output}{Path to the output PNG file or directory, or a function that
takes an input file path and returns an output path. When optimizing a
directory, \code{output} should be a directory path or a function.}

\item{level}{Optimization level (0-6). Higher values result in better
compression but take longer.}

\item{alpha}{Optimize transparent pixels for better compression. This is
technically lossy but visually lossless.}

\item{preserve}{Preserve file permissions and timestamps.}

\item{recursive}{When \code{input} is a directory, recursively process subdirectories.}

\item{verbose}{Print file size reduction info for each file.}
}
\value{
Character vector of output file paths (invisibly).
}
\description{
Optimize PNG files or directories of PNG files using lossless compression.
}
\examples{
# Create a test PNG
tmp = tempfile()
png(tmp, width = 400, height = 400)
plot(1:10)
dev.off()

# Optimize with different levels
optim_png(tmp, paste0(tmp, "-o1.png"), level = 1)
optim_png(tmp, paste0(tmp, "-o6.png"), level = 6)
}
