## ----echo = FALSE-------------------------------------------------------------
library("tind")

## ----color--------------------------------------------------------------------
library("tind")

## -----------------------------------------------------------------------------
(ys <- tind(y = 2010:2020))

## -----------------------------------------------------------------------------
(ys <- as.tind(2010:2020))

## -----------------------------------------------------------------------------
(ys <- as.tind(c(1700, 1800, 1900, 2000, 2100), type = "y"))

## -----------------------------------------------------------------------------
(ys <- as.year(c(1700, 1800, 1900, 2000, 2100)))

## -----------------------------------------------------------------------------
(ys <- as.tind(c("1700", "1800")))

## -----------------------------------------------------------------------------
(ys <- as.tind(c("1700", "1800", "1900", "2000", "2100"), format = "%Y"))

## -----------------------------------------------------------------------------
(ys <- as.tind(c("98", "99", "00", "01", "02"), format = "%y"))
format(ys, "%Y")
format(ys, "%y")

## -----------------------------------------------------------------------------
(ys <- as.year(c("98", "99", "00", "01", "02")))

## -----------------------------------------------------------------------------
options("tind.abbr.year.start")

## -----------------------------------------------------------------------------
(qs <- tind(y = rep(2020:2023, each = 4), q = 1:4))

## -----------------------------------------------------------------------------
(qs <- as.tind(c("2020Q1", "2020Q2", "2020Q3", "2020Q4")))
format(qs)
format(qs, "%YQ%q")

## -----------------------------------------------------------------------------
as.tind("2023.2", format = "%Y.%q")

## -----------------------------------------------------------------------------
as.tind("2023.2", order = "yq")

## -----------------------------------------------------------------------------
as.tind(c("2020 1", "2020 2", "2020 3", "2020 4"), type = "q")

## -----------------------------------------------------------------------------
as.quarter(c("2020 1", "2020 2", "2020 3", "2020 4"))

## -----------------------------------------------------------------------------
yf2tind(2020 + (0:3) / 4, "q")

## -----------------------------------------------------------------------------
(ms <- tind(y = 2023, m = 1:12))

## -----------------------------------------------------------------------------
format(ms)
format(ms, "%Y-%m")

## -----------------------------------------------------------------------------
as.tind("2023-11", type = "m")

## -----------------------------------------------------------------------------
as.month("2023-11")

## -----------------------------------------------------------------------------
(shrtms <- format(ms, "%b %y", locale = "C"))

## -----------------------------------------------------------------------------
as.tind(shrtms, format = "%b %y", locale = "C")
as.tind(shrtms, order = "my", locale = "C")

## -----------------------------------------------------------------------------
yf2tind(2020 + (0:11) / 12, "m")

## -----------------------------------------------------------------------------
(ws <- tind(y = 2024, w = 1:52))

## -----------------------------------------------------------------------------
format(ws)
format(ws, format = "%G-W%V")

## -----------------------------------------------------------------------------
as.week("2024-W51")

## -----------------------------------------------------------------------------
tind(m = 3, d = 15, y = 2024)
(ds <- tind(y = 2024, m = rep(1:3, each = 2), d = c(1, 16)))

## -----------------------------------------------------------------------------
format(ds)
format(ds, format = "%Y-%m-%d")
format(ds, format = "%F")

## -----------------------------------------------------------------------------
as.date("2024-12-31")

## -----------------------------------------------------------------------------
as.date("12/31/24")
format(as.date("12/31/24"), "%m/%d/%y")
format(as.date("12/31/24"), "%D")

## -----------------------------------------------------------------------------
(chds <- format(ds, "%b %d, %y", locale = "C"))
as.tind(chds, order = "mdy", locale = "C")

## -----------------------------------------------------------------------------
tind(H = 0:23)
tind(H = 13, M = (0:3) * 15)
(tod1 <- tind(H = 13, M = 30, S = (0:11) * 5))

## -----------------------------------------------------------------------------
(tod2 <- tind(H = 13, M = 30, S = 17 + (0:9) / 10))

## -----------------------------------------------------------------------------
format(tod1, "%H:%M")
format(tod1, "%H:%M:%S")
as.tind("13:47", format = "%H:%M")
as.tind("13:47:39", format = "%H:%M:%S")

## -----------------------------------------------------------------------------
format(tod2, "%H:%M:%S")
format(tod2, "%H:%M:%OS1")
format(tod2, "%H:%M:%OS2")
format(tod2, "%H:%M:%OS3")

## -----------------------------------------------------------------------------
as.tind("13:47:39.89", format = "%H:%M:%OS")

## -----------------------------------------------------------------------------
as.tind("13", order = "H")
as.tind("13:47", order = "HM")
as.tind("13:47:39", order = "HMS")
as.tind("13:47:39.9", order = "HMS")
as.tind("13:47:39.89", order = "HMS")

## -----------------------------------------------------------------------------
format(tind(H = 0:23), "%I %p")
as.tind("9:30am", format = "%I:%M%p")

## -----------------------------------------------------------------------------
as.tind("9:30am", order = "IMp")

## -----------------------------------------------------------------------------
tind(y = 2024, m = 8, d = 2, H = 16)
tind(y = 2024, m = 8, d = 2, H = 16, M = (0:3) * 15)
tind(y = 2024, m = 8, d = 2, H = 16, M = 0, S = 10 * (0:5))

## -----------------------------------------------------------------------------
tind(y = 2024, m = 8, d = 2, H = 16, M = (0:3) * 15, tz = "UTC")

## -----------------------------------------------------------------------------
(dt1 <- date_time(tind(y = 2024, m = 8, d = 2),
                  tind(H = 16, M = (0:3) * 15)))
(dt2 <- date_time(tind(y = 2024, m = 8, d = 2),
                  tind(H = 16, M = (0:3) * 15), tz = "UTC"))

## -----------------------------------------------------------------------------
date_time_split(dt1)

## -----------------------------------------------------------------------------
as.data.frame(date_time_split(dt1))

## -----------------------------------------------------------------------------
as.character(dt1)
as.character(dt2)
format(dt1)
format(dt2)

## -----------------------------------------------------------------------------
format(dt1, "%F %H:%M")
format(dt1, "%F %H:%M%z")
format(dt1, "%F %H:%M %Z")
format(dt1, "%D %I:%M%p")

## -----------------------------------------------------------------------------
as.tind("2025-02-01 13:03")
as.tind("2025-02-01 13:03:34")
as.tind("2025-02-01 13:03:34.534")

## -----------------------------------------------------------------------------
as.tind("2025-02-01 13:03:34.534", format = "%F %H:%M:%OS")
as.tind("02/01/25 01:03:34pm", format = "%D %I:%M:%OS%p")
as.tind("2025-02-01 13:03:34.534", order = "ymdHMS")
as.tind("2025-02-01 13:03:34.534", order = "ymdHMS", tz = "UTC")
as.tind("02/01/25 01:03:34pm", order = "mdyIMSp")
as.tind("02/01/25 01:03:34pm", order = "mdyIMSp", tz = "UTC")

## -----------------------------------------------------------------------------
as.tind("2025-02-22 09:54:04 CET", tz = "Europe/Warsaw")
as.tind("2025-08-23 09:54:04 CEST", tz = "Europe/Warsaw")
as.tind("2/22/25 9:54 a.m. EST", order = "mdyIMpz", tz = "America/New_York")
as.tind("8/23/25 9:54 a.m. EDT", order = "mdyIMpz", tz = "America/New_York")

## -----------------------------------------------------------------------------
as.tind("2025-02-22 09:54:04 CET")
as.tind("2025-08-23 09:54:04 CEST")
as.tind("2/22/25 9:54 a.m. EST", order = "mdyIMpz")
as.tind("8/23/25 9:54 a.m. EDT", order = "mdyIMpz")

## -----------------------------------------------------------------------------
as.tind(0:9, type = "i")
as.tind(0:9 / 10, type = "n")

## -----------------------------------------------------------------------------
ms
as.quarter(ms)
as.year(ms)
as.date(ms)
as.date_time(ms)
as.date_time(ms, tz = "UTC")

## -----------------------------------------------------------------------------
ds
as.Date(ds)
dt1
as.POSIXct(dt1)
dt2
as.POSIXlt(dt2)

## -----------------------------------------------------------------------------
(x <- as.date("2025-03-02") + 15 * (0:5))
(table <- as.month("2025-03") + -1:1)
match_t(x, table)

## -----------------------------------------------------------------------------
x %in_t% "2025-03"

## -----------------------------------------------------------------------------
x >= "2025-04"
x < "2025-04"

## -----------------------------------------------------------------------------
cut(x, "m")
cut(x, "q")

