% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_pca_individuals.R, R/spec_pca_wn_contrib.R
\name{spec_pca_wn_contrib}
\alias{spec_pca_wn_contrib}
\title{Compute Wavenumber Contributions to Principal Components}
\usage{
spec_pca_wn_contrib(PCA)

spec_pca_wn_contrib(PCA)
}
\arguments{
\item{PCA}{An object of class `prcomp`, containing the results of a principal component analysis.}
}
\value{
A tibble containing the wavenumber column and the percentage contribution of each
wavenumber to each principal component.

A tibble containing the wavenumber column and the percentage contribution of each
wavenumber to each principal component.
}
\description{
This function calculates the contribution of each wavenumber to the principal components (PCs)
in a PCA result. Contributions are computed as the squared loadings multiplied by 100.

This function calculates the contribution of each wavenumber to the principal components (PCs)
in a PCA result. Contributions are computed as the squared loadings multiplied by 100.
}
\details{
The function extracts the PCA loadings (rotation matrix) and computes the squared
values of each loading, scaled to percentage values. This helps interpret the importance of
each wavenumber in defining the principal components.

The function extracts the PCA loadings (rotation matrix) and computes the squared
values of each loading, scaled to percentage values. This helps interpret the importance of
each wavenumber in defining the principal components.
}
\examples{
\donttest{
pca_result <- spec_pca(CoHAspec)
wn_contrib <- spec_pca_wn_contrib(pca_result)
print(wn_contrib)
}

\donttest{
pca_result <- spec_pca(CoHAspec)
wn_contrib <- spec_pca_wn_contrib(pca_result)
print(wn_contrib)
}

}
