% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_misc.R
\name{align_matrices}
\alias{align_matrices}
\title{Align Q matrices}
\usage{
align_matrices(mat)
}
\arguments{
\item{mat}{List of dataframes or matrices with q-values.}
}
\value{
List of dataframes with aligned clusters.
}
\description{
Align list of q-matrices (matrices with values from 0 to 1) with consistent
row numbers. It is meant for the alignment q-matrices derived from
STRUCTURE (Pritchard et al. 2000) or similar software.
}
\details{
It can handle matrices with similar and different number of columns.
Matrices in the list are sorted by increasing number of columns and
the clusters from the first matrix are used as a reference for
ordering clusters from successive q-matrices
in the list.
}
\references{
Pritchard, J. K., Stephens, M., & Donnelly, P. (2000).
\emph{Inference of population structure using multilocus genotype data}
Genetics, 155(2), 945-959.
}
\keyword{internal}
