
<!-- README.md is generated from README.Rmd. Please edit that file -->

# **thisplot** <img src="man/figures/logo.svg" align="right" width="120"/>

<!-- badges: start -->

[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/thisplot)](https://CRAN.R-project.org/package=thisplot)
[![develop-ver](https://img.shields.io/github/r-package/v/mengxu98/thisplot?label=develop-ver)](https://github.com/mengxu98/thisplot/)
[![R-CMD-check](https://github.com/mengxu98/thisplot/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/mengxu98/thisplot/actions/workflows/R-CMD-check.yaml)
[![test-coverage](https://github.com/mengxu98/thisplot/actions/workflows/test-coverage.yaml/badge.svg)](https://github.com/mengxu98/thisplot/actions/workflows/test-coverage.yaml)
[![pkgdown](https://github.com/mengxu98/thisplot/actions/workflows/pkgdown.yaml/badge.svg)](https://mengxu98.github.io/thisplot/reference/index.html)
[![RStudio CRAN mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/thisplot)](https://CRAN.R-project.org/package=thisplot)

<!-- badges: end -->

## **Introduction**

[thisplot](https://mengxu98.github.io/thisplot/) is an *R* package
providing utility functions for data visualization and plotting. It
includes tools for color manipulation (blending, conversion, palettes),
plot customization (themes, grob operations, patchwork building), panel
size control, data optimization for plots, and layout adjustments.
Designed to enhance workflows with
[ggplot2](https://github.com/tidyverse/ggplot2),
[patchwork](https://github.com/thomasp85/patchwork), and
[ComplexHeatmap](https://github.com/jokergoo/ComplexHeatmap).

## **Chinese traditional colors**

[thisplot](https://mengxu98.github.io/thisplot/) provides a
comprehensive *Chinese traditional color* system with **1058**
representative colors. Use `ChineseColors()` to create a color object,
access colors by name (pinyin or Chinese), visualize the collection with
`visual_colors()`, and retrieve specific palettes using `get_colors()`.

Example usage:

``` r
library(thisplot)
cc <- ChineseColors()
cc
#> 
#> ── Chinese Traditional Colors System
#> 
#> ── Total 1058 colors
#> • blue: 92 colors
#> • cyan: 51 colors
#> • gray_brown: 323 colors
#> • green: 123 colors
#> • orange: 92 colors
#> • purple: 95 colors
#> • red: 181 colors
#> • yellow: 101 colors
#> 
#> ── Methods:
#> • visual_colors(loc_range, num_per_row, title, name_type)
#> 
#> ── See also:
#> • [get_colors()] for searching colors
```

``` r
cc$visual_colors(
  num_per_row = 30,
  title = "Chinese traditional colors",
  name_type = "chinese"
)
```

<div style="background:transparent;padding:12px;border-radius:12px;border:1px solid rgba(0,0,0,0.1);box-shadow:none;display:inline-block;overflow-x:auto;">
<div style="font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;font-size:13px;font-weight:600;color:inherit;margin-bottom:3px;">Chinese traditional colors</div>
<table style="border-collapse:separate;border-spacing:3px;">
<tbody>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#0F1423;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">钢<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#131824;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">燕<br>颔<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#101F30;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暗<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#142334;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">钢<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#12264F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">骐<br>驎</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1C2938;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸽<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#132C33;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">深<br>灰<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1A2847;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">花<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#003460;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">帝<br>释<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#19325F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">佛<br>头<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#21373D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">灰<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#003371;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绀<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#213A70;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">靛<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#003D74;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绀<br>宇</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#38308E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蓝<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1C3F73;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">阴<br>丹<br>士<br>林</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#22406A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">琉<br>璃<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#06436F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蓝<br>采<br>和</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#134857;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#144A74;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鷃<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#454659;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">䒌<br>靘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#45465E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>黛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#354E6B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>雀<br>头<br>黛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#12507B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>城</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2E4E7E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藏<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#26499D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">吴<br>须</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#004EA2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">景<br>泰<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#535164;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">曾<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2A5390;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>花<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#424D99;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">湛<br>蓝</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#15559A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>涛<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#0F59A4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">飞<br>燕<br>草<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1661AB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">靛<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#11659A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">搪<br>磁<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#106898;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柔<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#126E82;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>鈫<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4B5CC4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">宝<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#126BAE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柏<br>林<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4F64AE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#346C9C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>军<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3170A7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">安<br>安<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1772B4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">群<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3271AE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>冥</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2B73AF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">品<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2474B5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">尼<br>罗<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1177B0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">牵<br>牛<br>花<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1677B3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">天<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2376B7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">花<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2177B8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">虹<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5E7987;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>蓝<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4E7CA1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蝶<br>翅<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5976BA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>苍</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6B798E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菘<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1781B5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">釉<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4182A4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">吐<br>绶<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2983BB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">潮<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2486B9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">宝<br>石<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#158BB8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸢<br>尾<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2F90B9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">云<br>山<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1A94BC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">钴<br>蓝</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4994C4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">孔<br>雀<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5698C3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">睛<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6F94CD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">监<br>德</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#619AC3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">羽<br>扇<br>豆<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#22A2C3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8D93C8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">霁<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6E9BC5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">挼<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#66A9C9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">涧<br>石<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8BA3C7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">东<br>方<br>既<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5CB3CC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8AABCC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">品<br>月</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#88ABDA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">窃<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8FB2C9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">晴<br>山<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#63BBD0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">霁<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3CBEE7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">天<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#93B5CF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">星<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8ABCD1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">秋<br>波<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#85C0DB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缥<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A3BBDB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">晴<br>山</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BACCD9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">云<br>水<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#93D5DC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">清<br>水<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A2D2E2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">云<br>门</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#30DFF3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">湖<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AED0EE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>落</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B0D5DF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">湖<br>水<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C7D2D4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸥<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BCD4E7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">星<br>郎</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C3D7DF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">井<br>天<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3EEDE7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D0DFE6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">远<br>天<br>蓝</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C6E6E8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>天<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2F0F4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#13393E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">螺<br>子<br>黛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#284852;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>緺</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#424C50;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸦<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3B5554;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黛<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#41555D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黯</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#426666;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黛<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#226B68;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">䌦<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#006D87;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">软<br>翠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#007175;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>雘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#32788A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鱼<br>师<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#547689;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">太<br>师<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3B818C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蜻<br>蜓<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6B7D73;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">千<br>山<br>翠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#108B96;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">法<br>翠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3D8E86;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">铜<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1491A8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">樫<br>鸟<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#648E93;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">晚<br>波<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#668F8B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">空<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#509296;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">扁<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#0F95B0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">胆<br>矾<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1E9EB3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翠<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7397AB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>黑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5DA39D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">二<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#869D9D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">虾<br>壳<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5AA4AE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">天<br>水<br>碧</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7F9FAF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">竹<br>月</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#80A492;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缥<br>碧</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#10AEC2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">甸<br>子<br>蓝</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6CA8AF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">正<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#0EB0C9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">孔<br>雀<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7CABB1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">闪<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#88ADA6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#29B7CB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蔚<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2BBABE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">松<br>石</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#48C0A3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>碧</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#98B6C2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">白<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#57C3C2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#99BCAC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>筤</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#51C4D3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瀑<br>布<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#88BFB8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">總<br>犗</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#87C0CA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">西<br>子</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A4C9CC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">井<br>天</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BACAC6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">老<br>银</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BBCDC5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蟹<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B1D5C8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">沧<br>浪</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#25F8CB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">湖<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C0EBD7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D5EBE1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">天<br>缥</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E0EEE8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸭<br>卵<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E0F0E9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">素</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EEF7F2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">月<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#141E1B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莽<br>丛<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#15231B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">云<br>杉<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1F2623;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苷<br>蓝<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2B312C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">槲<br>寄<br>生<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1A3B32;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">深<br>海<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#253D24;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">油<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#223E36;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>绿</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3F503B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">螺<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#485B4D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">白<br>屈<br>菜<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1A6840;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">荷<br>叶<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#555F4D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">结<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4E6548;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莓<br>莓</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#446A37;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翠<br>虬</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2A6E3F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">官<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#176F58;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">祖<br>母<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5E665B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">田<br>螺<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4F6F46;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#057748;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">松<br>花<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5D7259;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">油<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#497568;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">飞<br>泉<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4F794A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芰<br>荷</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#207F4C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">薄<br>荷<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5F766A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翕<br>赩</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#248067;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>王<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4C8045;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翠<br>微</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#20894D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">宫<br>殿<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5D8351;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">漆<br>姑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#428675;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">亚<br>丁<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#298A7C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>翠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6C8650;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葱<br>倩</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#229453;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">孔<br>雀<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6A8D52;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>发</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6E8B74;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瓦<br>松<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#788A6F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雀<br>梅</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#698E6A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菉<br>竹</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3C9566;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蟾<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#778A77;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>梅</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2C9678;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>矾<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#868C4E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">风<br>入<br>松</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#579572;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蛋<br>白<br>石<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#519673;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#68945C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">庭<br>芜<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#779649;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>山</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#938F4C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绿<br>沈</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#0AA344;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>葱</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#20A162;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翠<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#12A182;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蓝<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#769C4C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">竹<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#00A48D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#21A675;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">松<br>柏<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1BA784;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">竹<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#63A545;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#22AC38;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绿<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#819D8E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翠<br>涛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7DA32D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柳<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#12AA9C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">美<br>蝶<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#41AE3C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">宝<br>石<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#81A380;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>楸</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2BAE85;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">铜<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#90A07D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>滋</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5BAE23;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹦<br>鹉<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#84A729;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>龙<br>吟</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#69A794;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">梧<br>枝<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#43B244;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鲜<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#61AC85;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#41B349;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>髓<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#83A78D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">松<br>霜<br>绿</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#45B787;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蛙<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#68B88E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">田<br>园<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#55BB8A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">麦<br>苗<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5DBE8A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蔻<br>梢<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#92B3A5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">浪<br>花<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9BB496;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">渌<br>波</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#66C18C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">毛<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9EBC19;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">人<br>籁</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A8B78C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">兰<br>苕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8CC269;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#96C24E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芽<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A6BAB1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">醽<br>醁</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#98C446;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">豆<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A9BE7B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">春<br>辰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9ABEAF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>原<br>远<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A8BF8F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>葭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B3BDA9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>古</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A0C777;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葱<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#83CBAC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">粉<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#96CE54;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">豆<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BEC936;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橄<br>榄<br>黄<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9ECCAB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">明<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A4CAB6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>簪<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2ADD9C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#00E09E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B2CF87;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橄<br>榄<br>石<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BACF65;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苹<br>果<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B7D07A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芦<br>苇<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BECAB7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">冰<br>台</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B7D332;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翠<br>缥</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A3D900;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葱<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3DE1AD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翡<br>翠<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C0D09D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">麹<br>尘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ADD5A2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">嘉<br>陵<br>水<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CDD171;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">翠<br>樽</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BED2BB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">山<br>岚</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AFDD22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柳<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C0D695;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">欧<br>碧</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C3D94E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>粲</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BDDD22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">嫩<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CAD3C3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">艾<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C9DD22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柳<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2D97A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">槐<br>花<br>黄<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CAD7C5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葭<br>菼</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B9DEC9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">竹<br>篁<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7FECAD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缥</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D0DEAA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">姚<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D8DE8A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绮<br>钱</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C6DFC8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>翠<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4E2D4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">秘<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D5E3D4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">卵<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E2E7BF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>沬<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E3EB98;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">少<br>艾</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DFECD5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">艾<br>背<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EDF1BB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葱<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0F5E5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">嫩<br>菊<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5F4321;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">龙<br>战</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7C461E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>瓯</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#775039;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">栗<br>壳</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9F6027;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>流</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8B7042;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">流<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A78E44;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">乌<br>金</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B78B26;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">山<br>鸡<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B78D12;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">枯<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BE8A2F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蛾<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D08635;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">郁<br>金<br>裙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BE9457;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>埒</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AD9E55;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>灰<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E18A3B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">库<br>金</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B6A014;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CE9747;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">琥<br>珀</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DB9B34;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>不<br>老</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D6A01D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">土<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D3A237;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鞠<br>衣</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2A36C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芸<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D9A40E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芥<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F49D2D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柘<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E5A84B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>河<br>琉<br>璃</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2B116;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">新<br>禾<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CAB272;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>封</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D5B210;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">香<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2B42C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EAAD1A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">虎<br>皮<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E8B004;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">谷<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EBB10D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">栀<br>子<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ECB34D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">铅<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E5B751;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">沙<br>石<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E4BF11;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">香<br>蕉<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBB612;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸡<br>蛋<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E2C027;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">姜<br>黄</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8B751;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雌<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCB70A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鼬<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DFC243;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蒿<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBB929;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹅<br>掌<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E2C17C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">浅<br>驼<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2BE45;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赤<br>金</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8BC31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">初<br>熟<br>杏<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FEBA07;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">琥<br>珀<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9BD10;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">浅<br>烙<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F3BF4C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">甘<br>草<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DDC871;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芒<br>果<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9C116;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">木<br>瓜<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F6C430;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹦<br>鹉<br>冠<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCC307;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>盏<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0C800;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">琉<br>璃<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9C600;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹅<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCC515;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>连<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F1CA17;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柚<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2C867;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">嫩<br>鹅<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBC82F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雅<br>梨<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EACD76;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFC90C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">乳<br>鸭<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2CE2B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">硫<br>华<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCCB16;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">素<br>馨<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E1D279;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">禹<br>余<br>粮</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EED045;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">秋<br>葵<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E1D384;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">田<br>赤</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FECC11;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">向<br>日<br>葵<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBCD31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">大<br>豆<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F4CE69;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">炒<br>米<br>黄</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ECD452;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缃<br>叶</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E2D849;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蝶<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FED110;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藤<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCD217;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>瓜<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCD337;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柠<br>檬<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9D367;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>密<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9D27D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">麦<br>芽<br>糖<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0D695;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">象<br>牙<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FED71A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">佛<br>手<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9D770;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>茧<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8D86A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葵<br>扇<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBDA41;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">油<br>菜<br>花<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FEDA5A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">栀<br>子</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F7DA94;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">香<br>水<br>玫<br>瑰<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FEDC5E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>鹂<br>留</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ECE093;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绢<br>纨</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EEDEB0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">牙<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8DF70;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">麦<br>秆<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8DF72;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茉<br>莉<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F7DE98;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">篾<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EBE1A9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莺<br>儿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F6DEAD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">酪<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8E0B0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>肉<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCE56C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2E6CE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">荔<br>肉<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ECEBC2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">断<br>肠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8E8C1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">豆<br>汁<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFEF3F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">明<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFEE6F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">松<br>花</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F7EEAD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">女<br>贞<br>黄</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9ECC3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">杏<br>仁<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9F172;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缃<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FDF371;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">檗<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EAFF56;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">樱<br>草<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFF799;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>白<br>游</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FAFF72;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸭<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFBC7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">半<br>见</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A64036;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>草</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9F5221;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">韎<br>韐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BA5140;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">纁<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D23918;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">洛<br>神<br>珠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B15A43;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棠<br>梨</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CB4601;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">曙<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BA5B49;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赤<br>缇</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CB523E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赩<br>炽</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C35C5D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">牙<br>绯</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C1651A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">槟<br>榔<br>综</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CC5D20;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">光<br>明<br>砂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BC6E37;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">媚<br>蝶</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E94829;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">檎<br>丹</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B97500;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>栌</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EA5514;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>丹</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CF7543;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">余<br>烬<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DD6B4F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">岱<br>赭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E46828;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>驼</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF632B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">龙<br>睛<br>鱼<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DF7140;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暮<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FA5D19;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莓<br>酱<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DE7622;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">麂<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED6D3D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苕<br>荣</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED6D46;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>柿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FC6315;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">燕<br>颔<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF6F48;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>莓<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E07B37;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丹</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F86B1D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>莲<br>花<br>橙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D77F66;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">琼<br>琚</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E67762;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">小<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F27635;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蟹<br>壳<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DB8540;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">醉<br>瓜<br>肉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9723D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芙<br>蓉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EE7959;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缙<br>云</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C09351;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桂<br>皮<br>淡<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D9883D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">红<br>友</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F27B1F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FF7500;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橘<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EE8055;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">法<br>螺<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FC7930;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菠<br>萝<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F97D1C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橘<br>橙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FA7E23;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">美<br>人<br>焦<br>橙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DC9123;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">风<br>帆<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF845D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赪<br>尾</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DA9233;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">杏<br>子</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EA8958;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">晨<br>曦<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FB8B05;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">万<br>寿<br>菊<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F18F60;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赪<br>霞</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F68C60;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瓜<br>瓤<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FA8C35;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橙<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FF8936;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橘<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FC8C23;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">北<br>瓜<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DB9C5E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">椒<br>房</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FA8E16;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">杏<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F29400;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">萱<br>草<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FF8C31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">杏<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DE9E44;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">软<br>木<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0945D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>螺<br>橙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DA9E8C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">檀<br>唇</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DAA45A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玳<br>瑁<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F09C5A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鲑<br>鱼<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E7A23F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">凋<br>叶<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F29A76;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>颜<br>酡</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FF9900;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雄<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FB9968;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">野<br>蔷<br>薇<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCA104;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橙<br>皮<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FCA106;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">枇<br>杷<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBA414;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>橘<br>橙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F4A83A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>莺<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9A633;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">榴<br>萼<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DDB078;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">九<br>斤<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFA400;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橙<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F3A694;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>天<br>霞</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFA60F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>叶<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F6AD8F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>藏<br>花<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F5B087;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">骍<br>刚</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8B37F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玫<br>瑰<br>粉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBB957;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蜜<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F7C173;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">肉<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0C2A2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">扶<br>光</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EDC3AE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藕<br>荷</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8C387;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蛋<br>壳<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8C6B5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">十<br>样<br>锦</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9CB8B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瓜<br>瓤<br>粉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F7CDBC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">润<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F7CFBA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">介<br>壳<br>淡<br>粉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F6DCCE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">初<br>桃<br>粉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9DFCD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">米<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9E8D0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">落<br>英<br>淡<br>粉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBECDE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">荷<br>花<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBEEE2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>米<br>粉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FBF2E3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">粉<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4C1E1A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">麒<br>麟<br>竭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#631216;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">爵<br>头</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#62102E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葡<br>萄<br>酒<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#622A1D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玄<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#662B1F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">木<br>兰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#662B2F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">福<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7C1823;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">枣<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7C191E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">顺<br>圣</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#82111F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">殷<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#82202B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暗<br>紫<br>苑<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#822327;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">大<br>繎</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8F1D22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>樱</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#873424;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丹<br>秫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#95302E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>湛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9E2A22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">綪<br>茷</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A61B29;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苋<br>菜<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8F3D2C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">佛<br>赤</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A72126;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>华<br>朱</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AB1D22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">胭<br>脂<br>虫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AC1F18;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">覆<br>盆<br>子<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#954024;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赤<br>灵</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B81A35;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>孔<br>阳</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AF2E2B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玫<br>瑰<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#894E54;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">烟<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BC172D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">牡<br>丹<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AB372F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹅<br>血<br>石<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A73766;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">魏<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C21F30;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">枫<br>叶<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B13B2E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>榴<br>裙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C8161D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丹<br>雘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C12C1F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">珊<br>瑚<br>赫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C02C38;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">高<br>粱<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9E4E56;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>矿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CF002D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">红<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B93A26;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>殷</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C91F37;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CC163A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">尖<br>晶<br>玉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B83570;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">红<br>踯<br>躅</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B04552;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鞓<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BF3553;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">锦<br>葵<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A6522C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绀<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B0436F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">胭<br>脂<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D11A2D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹅<br>冠<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D70440;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A7535A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">满<br>江<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D42517;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹤<br>顶<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BD482A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赭<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C83C23;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绯</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BD482C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茜<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C04851;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DE1C31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">唐<br>菖<br>蒲<br>红</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E60012;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DE2A18;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">夕<br>阳<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E61030;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赤</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DC3023;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">酡<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D9333F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>榴<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2357D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玫<br>瑰<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CF4813;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">落<br>霞<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D13C74;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菠<br>根<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C25160;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">唇<br>脂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EB261A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丽<br>春<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F00056;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">品<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B95A89;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">胭<br>脂<br>水</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EC2B24;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">秋<br>海<br>棠<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C45A65;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莓<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EE2746;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>曙<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E8382C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>槿<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C35C6A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">美<br>人<br>祭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C35691;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">电<br>气<br>石<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED3321;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">樱<br>桃<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DE3F7C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">嫩<br>菱<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EC2C64;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">喜<br>蛋<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED3333;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">枸<br>枢<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CE576D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">月<br>季<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED2F6A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">榲<br>桲<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EC2D7A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藏<br>花<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED3B2F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鱼<br>鳃<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EE2C79;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>荆<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CC5595;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">龙<br>须<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D85916;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">铁<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E94709;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>砂</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CD6227;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">火<br>砖<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F03752;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>棠<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CB5C83;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">琅<br>玕<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF3473;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">品<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F13C22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">萝<br>卜<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EB3C70;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">松<br>叶<br>牡<br>丹<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F03F24;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">胭<br>脂<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2568C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丹<br>紫<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EE3F4D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茶<br>花<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F33B1F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">极<br>光<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F5391C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">铁<br>水<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F23E23;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">红<br>汞<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F43E06;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">银<br>朱</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F1441D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蜻<br>蜓<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CE5E8A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">吊<br>钟<br>花<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED4845;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>菽<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FF0097;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">洋<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2481B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柿<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F34718;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">榴<br>花<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FF3300;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">炎</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF475D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>茉<br>莉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F04B22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">大<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EE4863;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>竹<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F04A3A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">珊<br>瑚<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FF2D51;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">火<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EE4866;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>蕊<br>香<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED5126;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EB507E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">夹<br>竹<br>桃<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EA517F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莲<br>瓣<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF498B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">扁<br>豆<br>花<br>红</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED5736;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">妃<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EC4E8A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">兔<br>眼<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C5708B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">酢<br>酱<br>草<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F35336;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">彤</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED556A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">山<br>茶<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F15642;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苹<br>果<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E16723;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">陶<br>瓷<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED5A65;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">艳<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F05A46;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">曲<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BB7A8C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>梅</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F25A47;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桂<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DD6B7B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">渥<br>赭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DC6B82;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">长<br>春</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CC73A0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黪<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C27C88;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">山<br>黎<br>豆<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E16C96;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">初<br>荷<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D276A3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菱<br>锰<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DD7694;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苏<br>梅</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DE7897;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">白<br>芨<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EB6EA5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桃<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EA7293;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">凤<br>仙<br>花<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F17666;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">谷<br>鞘<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CE8892;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">縓<br>缘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EC7696;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>绛<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E77C8E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>茜<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF7A82;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">嫣<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DE82A7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">龙<br>膏<br>烛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F47983;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桃<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F07C82;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">香<br>叶<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CF929E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雌<br>霓</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EF82A0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">霞<br>光<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D993AB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菡<br>萏</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EC8AA4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">报<br>春<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F1908C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">榴<br>子<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F091A0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">杨<br>妃</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F1939C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">春<br>梅<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F19790;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">舌<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EB9A9A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">红<br>梅<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D9A0B3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莲<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EC9BAD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">粉<br>团<br>花<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E2A2AC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">彤<br>管</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EEA08C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>罂<br>粟<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ED9DB2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">豇<br>豆<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EBA0B3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芍<br>药<br>耕<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DAA9A9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">咸<br>池</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EEA2A4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">牡<br>丹<br>粉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0A1A8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">合<br>欢<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EEA6B7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">晶<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EFAA9C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">颊<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E3ADB9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">夕<br>岚</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0ADA0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桃<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EFAFAD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">无<br>花<br>果<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E3B4B8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鼠<br>鼻<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ECB0C1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E4B8D5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">樱<br>花</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EEB8C3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">姜<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2B9B2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">粉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F6BEC8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桃<br>夭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EFC4CE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">粉<br>米</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F1C4CD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>红</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F4C7BA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">洋<br>水<br>仙<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E7CAD3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">银<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0C9CF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>蕊<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2CAC9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>绯</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F6CEC1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>桃<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EDD1D8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藕<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0CFE3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">退<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F3D3E7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9D3E3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">盈<br>盈</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8EBE6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>珠<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1C0D1A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">深<br>牵<br>牛<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#131124;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暗<br>蓝<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1E131D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">乌<br>梅<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2D0C13;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茄<br>皮<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2B1216;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">李<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#310F1B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">墨<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#30161C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">卵<br>石<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#33141E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">火<br>鹅<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#22202E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暗<br>龙<br>胆<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#420B2F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">油<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1F2040;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">晶<br>石<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#500A16;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">金<br>鱼<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4D1018;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">酱<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#461629;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绀<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#382129;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">磨<br>石<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#411C35;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">荸<br>荠<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#56004F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>棠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4B1E2F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>象<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4C1F24;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葡<br>萄<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5A1216;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葡<br>萄<br>酱<br>紫</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#63071C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>竹<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#541E24;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">猪<br>肝<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5A191B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">栗<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#422256;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">凝<br>夜<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#322F3B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">龙<br>葵<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#302F4B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">野<br>葡<br>萄<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#621624;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">甘<br>蔗<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5C2223;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暗<br>玉<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4E2A40;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">龙<br>睛<br>鱼<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#621D34;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹞<br>冠<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#681752;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">牵<br>牛<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2E317C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">满<br>天<br>星<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3E3841;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">剑<br>锋<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#602641;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芥<br>拾<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3B2E7E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藏<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5D3131;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">貂<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6C216D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">齐<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#643268;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茄<br>子</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7E1671;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">魏<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7E2065;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葛<br>巾<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5D3F51;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#574266;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黛<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8A1874;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赪<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#663D74;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">三<br>公<br>子</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#951C48;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菜<br>头<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#425066;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黛<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8B2671;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>莲</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9B1E64;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苋<br>菜<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4A4B9D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">延<br>维</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#813C85;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桔<br>梗<br>紫</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#525288;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">野<br>菊<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#814662;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">地<br>血</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8C4356;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绛<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#894276;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芓<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#983680;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芥<br>花<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7E527F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">拂<br>紫<br>绵</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7D5284;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>紶</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#725E82;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">乌<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#615EA8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">优<br>昙<br>瑞</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A8456B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">洋<br>葱<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BA2F7B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玫<br>瑰<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7B59A3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#61649F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">山<br>梗<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#815C94;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蕈<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6B6882;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#995D7F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>府</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A6559D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>蒲</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A35C8F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">扁<br>豆<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#806D9E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">槿<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A76283;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>茎<br>屏<br>风</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#74759B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">螺<br>甸<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8076A3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藤<br>萝<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AD6598;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">豆<br>蔻<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#757CBB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>苑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C06F98;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">樱<br>草<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A67EB7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茈<br>藐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BA79B1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">木<br>槿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9B8EA9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>菂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BC84A8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>蛤<br>壳<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C08EAF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">萝<br>兰<br>紫</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CE93BF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丁<br>香</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A7A8BD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>蓝<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BBA1CB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>薄<br>汗</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B0A4E3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雪<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A4ABD6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暮<br>山<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C8ADC4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">凤<br>信<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C8BBC9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>藤</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D1C2D3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>牵<br>牛<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CCCCD6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">远<br>山<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DCC7E1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">昌<br>荣</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E0C8D1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>青<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E9CCD3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芝<br>兰<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E9D7DF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丁<br>香<br>淡<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EDE3E7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">马<br>鞭<br>草<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2E7E5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>藤<br>萝<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#100011;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黑<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#161823;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">漆<br>黑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#151D29;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">獭<br>见</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#440E25;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">古<br>铜<br>紫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2C2321;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">墨<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#1E2732;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瑾<br>瑜</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#312520;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">煤<br>黑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#252A3A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">乌<br>黑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#481E1C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">豆<br>沙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#36282B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>蝇<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#422517;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>骊</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#36292F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">古<br>鼎<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4C221B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>檀</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2D2E36;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">牛<br>角<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#482522;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">火<br>山<br>棕</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2C2F3B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绀<br>蝶</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2F2F35;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">水<br>牛<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#31322C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">京<br>元</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3F2E2D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">酱<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#343041;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">璆<br>琳</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#2B333E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#482936;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">斑<br>鸠<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5A1F1B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">酱<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5C1E19;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">栗<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#35333C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">沙<br>鱼<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#363433;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">长<br>石<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#592620;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暗<br>驼<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#493131;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缁<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#393733;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">河<br>豚<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#373834;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蒽<br>油<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#483332;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>报<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#60281E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">栗<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#652B1C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">可<br>可<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5B3222;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">目<br>童<br>子</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3D3B4F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玄<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#692A1B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">柞<br>叶<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4F383E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暮<br>云<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#672E1D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>砂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5C3719;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">古<br>铜<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#513C20;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蟹<br>壳<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#553B18;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">焦<br>茶<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#533C1B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">古<br>铜<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#503E2A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橄<br>榄<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4A4035;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹤<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4D4030;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>松<br>烟</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#673424;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>栗<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#4F4032;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">松<br>鼠<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#46433B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">驖<br>骊</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#732E12;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">筍<br>皮<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#68361A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">枣<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5D3D21;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茶<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#584019;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">皂<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#683632;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蜜<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#3C4654;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">霁<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#603D30;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">中<br>灰<br>驼</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#753117;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">咖<br>啡</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#71361D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丁<br>香<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#45493D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绿<br>云</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5B423A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>铁<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#47484C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瓦<br>罐<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#862617;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赭<br>石</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#584717;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">暗<br>海<br>水<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#474B4C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>昏<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5B4913;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棕<br>榈<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#863020;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">火<br>岩<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#66462A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">驼<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#773D31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橡<br>树<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5A4C3B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>艾</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#64483D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">珠<br>母<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#624941;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>板<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#594C57;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>鼠</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#813C33;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玳<br>瑁</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#72453A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">椒<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#475164;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鲸<br>鱼<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#644D31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">油<br>葫<br>芦</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#883A1E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">椰<br>壳<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#694B3C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">麝<br>香<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5C4F55;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">烟<br>墨</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#595333;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">素<br>綦</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#585248;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">墨<br>黪</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5E5314;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">橄<br>榄<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#873D24;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>豆<br>沙</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7C4449;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">霁<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6A5037;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黧</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7C4B00;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棕<br>黑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8F3F00;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">褐<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#81492C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">朱<br>石<br>栗</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#645822;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">潭<br>水<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#804C2E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">緅<br>絺</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#495C69;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">战<br>舰<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6B5458;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玄<br>天</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#665757;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黝<br>黑</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#585878;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绀</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#954416;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芒<br>果<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8C4B31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>土<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9B4400;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棕<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#76555D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>诰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#73575C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鼠<br>背<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6D5C3D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">伽<br>罗</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#685E48;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">燕<br>羽<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#695E45;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蟹<br>壳<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#665F4D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">冥<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#6A5B6D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸦<br>雏</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#964D22;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">岩<br>石<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#815463;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>酱</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5E616D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鱼<br>尾<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7C5B3E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">驼<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#576470;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">育<br>阳<br>染</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#5D655F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">狼<br>烟<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#984F31;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缊<br>韨</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#835E1D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蜴<br>蜊<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#815F25;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莱<br>阳<br>梨<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#945635;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">檀<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7C623F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">射<br>干</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#945833;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>咖<br>啡</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#975738;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棕<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#806332;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#75664D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黎</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#955A42;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棠<br>梨<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#686A67;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>涅</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#70695D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黑<br>朱</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#81663B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">远<br>志</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B14B28;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蟹<br>蝥<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8B614D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">中<br>红<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#796860;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">濯<br>绛</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#756C4B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">綟<br>绶</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#876818;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">粽<br>叶<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8A6913;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">灰<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#617172;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">夏<br>云<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#826B48;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">龟<br>背<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A85858;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蚩<br>尤<br>旗</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B7511D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>可<br>可<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#986524;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">山<br>鸡<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#896C39;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">秋<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A45F44;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">老<br>僧<br>衣</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#827100;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棕<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#896D47;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">吉<br>金</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#867018;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">碧<br>螺<br>春<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A35F65;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茹<br>藘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9A6655;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赭<br>罗</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#856D72;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芦<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#906C4A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">荆<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#87723E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鲛<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8F6D5F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹰<br>背<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#887322;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苔<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7A7374;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">锌<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7F754C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绞<br>衣</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B05F42;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苏<br>方</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9E696D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葡<br>萄<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#74787A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">嫩<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#80766E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雁<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#887657;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茶<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#81776E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">深<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AA6A4C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">火<br>泥<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#737C7B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">垩<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7A7B78;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雷<br>雨<br>垂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#94784F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">大<br>云</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#877D52;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">荩<br>篋</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#847C74;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">夜<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AE7000;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">棕<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B26D5D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">檀<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#867E76;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瓦<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#79836C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苔<br>古</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8E804B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#FFFFFF;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>灰<br>绿</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#70887D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>绿<br>灰</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#918072;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">银<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#99806C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">沉<br>香</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#928187;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">红<br>藤<br>杖</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#91828F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">迷<br>楼<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B27777;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绛<br>纱</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#97846C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">猴<br>毛<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9E8358;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">降<br>真<br>香</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#758A99;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">墨<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9E8368;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">明<br>茶<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#92896B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绿<br>豆<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A98175;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绾</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#92897B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>莲<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AA8534;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">老<br>茯<br>神</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9A8878;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>鸥<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9D858F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">烟<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BE7E4A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>赭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CD7372;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">红<br>䵂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#92905D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>圭</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#86908A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蕉<br>月</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A58A5F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蒸<br>栗</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9E8C6B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>琮</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A88787;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藕<br>丝<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BD8253;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">露<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#7D929F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">秋<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#919177;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">执<br>大<br>象</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BC836B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>磨<br>金</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9C8D9B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">银<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AA8E59;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">巨<br>吕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#8A988E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">明<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AA9649;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">大<br>赤</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B49273;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>埃</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A29B7C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9D9D82;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">春<br>碧</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B89485;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>玫<br>瑰<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BD9683;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">丁<br>香<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A99F70;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">王<br>刍</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B49B7F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">养<br>生<br>主</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B598A1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">隐<br>红<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9FA0A0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">灰<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A9A082;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玄<br>校</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BF9C46;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">秋<br>香</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#AC9F8A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">佩<br>玖</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D99156;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹿<br>皮<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9FA39A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">镍<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C89B40;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">昏<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A8A19C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">绍<br>衣</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B7A091;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蛛<br>网<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B4A379;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>螺</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A9A773;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">出<br>岫</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#9AA7B1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>鸾</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B6A476;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">尘<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A9A886;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">琬<br>琰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C6A268;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">茧<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BFA670;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">沙<br>饧</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A7AAA1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">不<br>皂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B4A992;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">百<br>灵<br>鸟<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A4ACA7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">冰<br>山<br>蓝</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BFA782;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">大<br>块</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BEA78B;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">紫<br>花<br>布</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B5AA90;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">银<br>鼠<br>灰</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BEA89D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">珠<br>子<br>褐</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A8B092;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>玉<br>案</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C0AD5E;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">栾<br>华</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B7AE8F;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">月<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#A1AFC9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蓝<br>灰<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BDAEAD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芦<br>穗<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B3B59C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鸣<br>珂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BEB1AA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">葭<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C1B2A3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>银<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BDB2B2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">甘<br>石</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B2B6B6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">月<br>魄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BBB5AC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">中<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D3B17D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">枯<br>黄</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D2AF9D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">夏<br>籥</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D5B45C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">太<br>一<br>余<br>粮</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C4B798;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>梁</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BFB99C;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">行<br>香<br>子</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C8B5B3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>烟<br>落<br>照</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B2BBBE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">星<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C8B6BB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>英</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#B2BFC3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">逍<br>遥<br>游</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BFC096;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瓷<br>秘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C6BEB1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">云<br>母</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BFC1A9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">草<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E8B49A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>粉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BEC2B3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">冻<br>缥</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4BF89;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">石<br>蜜</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BEC2BC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">溶<br>溶<br>月</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DDBB99;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">如<br>梦<br>令</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C0C4C3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">月<br>影<br>白</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E3BD8D;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鹿<br>角<br>棕</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4C1A6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">假<br>山<br>南</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CAC5A0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">青<br>白<br>玉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C7C6B6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">霜<br>地</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E1C199;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">赤<br>璋</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4C4B7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">晓<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D5C8A0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缣<br>湘</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#BDCBD2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">影<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4C9AA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">仙<br>米</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DDC5B8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">肉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C4CBCF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">大<br>理<br>石<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C2CCD0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">花<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D3CBC5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">藕<br>丝<br>秋<br>半</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CFCCC9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玛<br>瑙<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C9CFC1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">余<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D3CCD6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">香<br>炉<br>紫<br>烟</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D5D1AE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">筠<br>雾</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DFCEB4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">地<br>籁</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#CDD1D3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">银<br>鱼<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D8D1C5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">香<br>皮</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4D3C1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">米<br>汤<br>娇</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4D3CA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">明<br>月<br>珰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#C4D7D6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">穹<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E5D3AA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莲<br>子<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DAD4CB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">浅<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DFD6B8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">黄<br>润</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E6D2D5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蓟<br>粉<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DFD7C2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蜜<br>合</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D1D9E0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">苍<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EAD89A;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">桑<br>蕾</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D4DDE1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">素<br>采</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#ECD9C7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">弗<br>肯<br>红</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E9DDB6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">菊<br>蕾<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E0DFC6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">天<br>球</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D3E0F3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">淡<br>青</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E0E0D0;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">韶<br>粉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#DFE0D9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">二<br>目<br>鱼</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E4DFD7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">珍<br>珠<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#D8E3E7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">云<br>峰<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E2E1E4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">芡<br>食<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EBE3C7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">骨<br>缥</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EAE4D1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EAE5E3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>頩</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EBEDDF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">吉<br>量</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F2ECDE;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缟</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EBEEE8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">皦<br>玉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EAEEF1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">浅<br>云</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E3EFFD;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">莹<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#EFEFEF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">缟<br>羽</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#E9F1F6;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">霜<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F1F0ED;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">银<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F0F0F4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">铅<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9F1DB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">蚌<br>肉<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F5F2E9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">凝<br>脂</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F5F3F2;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">山<br>矾</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F9F4DC;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">乳<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F7F4ED;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">鱼<br>肚<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F8F4ED;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">汉<br>白<br>玉</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F6F9E4;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">酇<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#F3F9F1;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">荼<br>白</div>
</div>
</td>
</tr>
<tr>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFBE7;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">练<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FDFCF3;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">玉<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFEF5;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">粉<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFEF8;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">象<br>牙<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFEF9;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">雪<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFEFA;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">海<br>参<br>灰</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFFFB;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">瓷<br>白</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:#FFFFFF;box-shadow:0 1px 2px rgba(0,0,0,0.2);text-align:center;vertical-align:middle;display:table-cell;position:relative;overflow:hidden;">
<div style="display:flex;align-items:center;justify-content:center;width:100%;height:100%;">
<div style="color:#000000;font-size:8px;font-family:&#39;Noto Sans SC&#39;,&#39;PingFang SC&#39;,&#39;Microsoft YaHei&#39;,sans-serif;letter-spacing:0.2px;line-height:1.2;display:block;text-align:center;width:100%;">白<br>色</div>
</div>
</td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
<td style="padding:2px 2px;width:21px;min-width:21px;max-width:21px;height:50px;min-height:50px;border-radius:3px;background:transparent;text-align:center;"></td>
</tr>
</tbody>
</table>
</div>

``` r
get_colors("Paired")
#> 
#> ── Found palette: "Paired"
#>       name             rgb     hex
#> 1  #A6CEE3 (166, 206, 227) #A6CEE3
#> 2  #1F78B4  (31, 120, 180) #1F78B4
#> 3  #B2DF8A (178, 223, 138) #B2DF8A
#> 4  #33A02C   (51, 160, 44) #33A02C
#> 5  #FDBF6F (253, 191, 111) #FDBF6F
#> 6  #FF7F00   (255, 127, 0) #FF7F00
#> 7  #FB9A99 (251, 154, 153) #FB9A99
#> 8  #E31A1C   (227, 26, 28) #E31A1C
#> 9  #CAB2D6 (202, 178, 214) #CAB2D6
#> 10 #6A3D9A  (106, 61, 154) #6A3D9A
#> 11 #FFFF99 (255, 255, 153) #FFFF99
#> 12 #B15928   (177, 89, 40) #B15928
```

``` r
get_colors("cyan", palettes = "ChineseSet64")
#> 
#> ── Searching in palette: "ChineseSet64"
#> 
#> ── Found in:
#> #108B96: "ChineseSet64"
#> #1491A8: "ChineseSet64"
#> #0F95B0: "ChineseSet64"
#> #1E9EB3: "ChineseSet64"
#> #10AEC2: "ChineseSet64"
#> #0EB0C9: "ChineseSet64"
#> #29B7CB: "ChineseSet64"
#>     num        name name_ch            rgb     hex category category_ch
#> 106 106       facui    法翠 (16, 139, 150) #108B96     cyan          青
#> 108 108 jianniaolan  樫鸟蓝 (20, 145, 168) #1491A8     cyan          青
#> 112 112   danfanlan  胆矾蓝 (15, 149, 176) #0F95B0     cyan          青
#> 113 113      cuilan    翠蓝 (30, 158, 179) #1E9EB3     cyan          青
#> 120 120   dianzilan  甸子蓝 (16, 174, 194) #10AEC2     cyan          青
#> 122 122  kongquelan  孔雀蓝 (14, 176, 201) #0EB0C9     cyan          青
#> 125 125      weilan    蔚蓝 (41, 183, 203) #29B7CB     cyan          青
```

## **Installation**

Install CRAN version:

``` r
install.packages("thisplot")
# or
if (!require("pak", quietly = TRUE)) {
  install.packages("pak")
}
pak::pak("thisplot")
```

Install development version from
[GitHub](https://github.com/mengxu98/thisplot) use
[pak](https://github.com/r-lib/pak):

``` r
if (!require("pak", quietly = TRUE)) {
  install.packages("pak")
}
pak::pak("mengxu98/thisplot")
```

## **Usage**

Please reference
[here](https://mengxu98.github.io/thisplot/reference/index.html).
