% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term.R
\name{term}
\alias{term}
\alias{term-object}
\alias{term_object}
\alias{term-vector}
\alias{term_vector}
\title{Create Term Vector}
\usage{
term(...)
}
\arguments{
\item{...}{Unnamed values are term values,
named values describe the parameter in the name
and the dimensionality in the value.}
}
\value{
A term vector.
}
\description{
Creates a term vector from values.
A \code{term} vector is an S3 vector of parameter terms
of the form \code{p}, \verb{q[#]} or \verb{r[#,#]} where \verb{#} are
positive integers.
This function checks that all terms are valid
but does not require stronger levels of consistency,
see \code{chk_valid()} for details.
}
\examples{
term()
term("p", "q[1]", "q[2]", "q[3]")
term("q[1]", "q[2]", "q[3]")
combined <- term(par = 2:4, "alpha")
pdims(combined)
term(!!!pdims(combined))

# Invalid terms are rejected:
try(term("r["))

# Valid terms are repaired
term("r  [ 1  ,2  ]")
}
\seealso{
\code{\link[=dims]{dims()}}, \code{\link[=ndims]{ndims()}}, \code{\link[=npdims]{npdims()}} and \code{\link[=pdims]{pdims()}}

Other term: 
\code{\link{term_rcrd}()},
\code{\link{tindex}()}
}
\concept{term}
