% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task.R
\name{task_clean}
\alias{task_clean}
\title{Remove All Tasks from a Project}
\usage{
task_clean(project, con = NULL)
}
\arguments{
\item{project}{Character string specifying the project name.}

\item{con}{An optional database connection. If NULL, a new connection is
created and closed automatically.}
}
\value{
Invisibly returns NULL. Called for side effects (truncating task table).
}
\description{
Deletes all tasks from a project's task table. This is a destructive
operation that removes all task data and history.
}
\details{
Uses SQL TRUNCATE to efficiently remove all rows from the task table.
This is faster than DELETE but cannot be rolled back.

\strong{Warning:} All task history, including completion status and runtime
information, will be permanently lost.

This function is automatically called by \code{\link{task_add}} when
\code{clean = TRUE}.
}
\examples{
\dontrun{
# Not run:
# Remove all tasks
task_clean("simulation_study")

# Add new tasks
task_add("simulation_study", num = 200)
}
}
\seealso{
\code{\link{task_add}}, \code{\link{task_reset}}
}
