% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rarefaction.R
\docType{methods}
\name{index_hurlbert}
\alias{index_hurlbert}
\alias{index_hurlbert-method}
\alias{index_hurlbert,numeric-method}
\title{Hurlbert's Rarefaction}
\usage{
index_hurlbert(x, ...)

\S4method{index_hurlbert}{numeric}(x, sample, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{sample}{A length-one \code{\link{numeric}} vector giving the sub-sample size.
The size of sample should be smaller than total community size.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Hurlbert's unbiased estimate of Sander's rarefaction.
}
\references{
Hurlbert, S. H. (1971). The Nonconcept of Species Diversity: A Critique and
Alternative Parameters. \emph{Ecology}, 52(4), 577-586.
\doi{10.2307/1934145}.

Sander, H. L. (1968). Marine Benthic Diversity: A Comparative Study.
\emph{The American Naturalist}, 102(925), 243-282.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()},
\code{\link{observed}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
