% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/similarity.R
\docType{methods}
\name{index_brainerd}
\alias{index_brainerd}
\alias{index_brainerd-method}
\alias{index_brainerd,numeric,numeric-method}
\title{Brainerd-Robinson Quantitative Index}
\usage{
index_brainerd(x, y, ...)

\S4method{index_brainerd}{numeric,numeric}(x, y)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Brainerd-Robinson Quantitative Index
}
\details{
A city-block metric of similarity between pairs of samples/cases.
}
\references{
Brainerd, G. W. (1951). The Place of Chronological Ordering in
Archaeological Analysis. \emph{American Antiquity}, 16(04), 301-313.
\doi{10.2307/276979}.

Robinson, W. S. (1951). A Method for Chronologically Ordering Archaeological
Deposits. \emph{American Antiquity}, 16(04), 293-301. \doi{10.2307/276978}.
}
\seealso{
Other beta diversity measures: 
\code{\link{index_binomial}()},
\code{\link{index_bray}()},
\code{\link{index_cody}()},
\code{\link{index_jaccard}()},
\code{\link{index_morisita}()},
\code{\link{index_routledge}},
\code{\link{index_sorensen}()},
\code{\link{index_whittaker}()},
\code{\link{index_wilson}()}
}
\author{
N. Frerebeau
}
\concept{beta diversity measures}
