% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask-type.R
\name{entmax}
\alias{entmax}
\alias{entmax15}
\title{Alpha-entmax}
\usage{
entmax(dim = -1)

entmax15(dim = -1L, k = NULL)
}
\arguments{
\item{dim}{The dimension along which to apply 1.5-entmax.}

\item{k}{The number of largest elements to partial-sort input over. For optimal
performance, should be slightly bigger than the expected number of
non-zeros in the solution. If the solution is more than k-sparse,
this function is recursively called with a 2*k schedule. If \code{NULL}, full
sorting is performed from the beginning.}
}
\value{
The projection result P  of the same shape as input, such that
\eqn{\sum_{dim} P = 1 \forall dim} elementwise.
}
\description{
With alpha = 1.5 and normalizing sparse transform (a la softmax).
}
\details{
Solves the optimization problem:
\eqn{\max_p <input, P> - H_{1.5}(P) \text{ s.t. } P \geq 0, \sum(P) == 1}
where \eqn{H_{1.5}(P)} is the Tsallis alpha-entropy with \eqn{\alpha=1.5}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
\dontrun{
input <- torch::torch_randn(10,5, requires_grad = TRUE)
# create a top3 alpha=1.5 entmax on last input dimension
nn_entmax <- entmax15(dim=-1L, k = 3)
result <- nn_entmax(input)
}
\dontshow{\}) # examplesIf}
}
