% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_functions.R
\name{compare_file_contents}
\alias{compare_file_contents}
\title{Compare contents of two files and determine synchronization status}
\usage{
compare_file_contents(
  path_left,
  path_right,
  verbose = getOption("syncdr.verbose")
)
}
\arguments{
\item{path_left}{A character string specifying the path to the file in the left directory.}

\item{path_right}{A character string specifying the path to the file in the right directory.}

\item{verbose}{logical; if TRUE display progress status of hashing files' contents, in seconds. Default is FALSE}
}
\value{
A list containing the following components:
\item{is_diff}{Logical. Indicates whether the contents of the two files are different (\code{TRUE})
or identical (\code{FALSE}).}
\item{sync_status_content}{Character. Describes the synchronization status between the
two files based on their content:
- "different content": Contents of the files are not identical.
- "same content": Contents of the files are identical.}
}
\description{
This function compares the contents of two files located at specified paths
and determines their synchronization status based on their content
}
\keyword{internal}
