\name{prior_probs}
\alias{prior_probs}
\title{Prior Probabilities of Grammatical Types}
\description{
Computes prior probabilities for each grammatical type (e.g., \code{S},
\code{V}, \code{Sx->S}, \code{xS->A}, etc.) from a dictionary. The priors
can be corrected for verb underrepresentation in the dictionary data.
}
\usage{
prior_probs(dic, sentence_prob = 1.0)
}
\arguments{
  \item{dic}{A dictionary data frame as returned by
    \code{\link{read_dictionary}}.}

  \item{sentence_prob}{Numeric in (0, 1]. The estimated proportion of
    complete sentences (as opposed to noun phrases) in the training data
    from which the dictionary was created. Verbs appear in complete
    sentences, so a value less than 1 upweights verb-like types.
    Default: 1.0.}
}
\details{
The function proceeds in three steps:

\enumerate{
  \item For each single-sign dictionary entry with at least one count,
    the counts per grammatical type are normalised to sum to 1.
  \item The prior probability of each type is the mean of these
    normalised frequencies across all signs.
  \item A correction is applied: counts of verb-like types (\code{V} and all
    operators with return type \code{V}, such as \code{Vx->V} or
    \code{xV->V}) are multiplied by \code{1/sentence_prob}, then all
    probabilities are renormalised. This compensates for the fact that
    verbs are underrepresented when most dictionary entries are obtained from noun
    phrases rather than complete sentences.
}

When \code{sentence_prob = 1}, no correction is applied.
}
\value{
A named numeric vector with one element per grammatical type found in
the dictionary, summing to 1. The names are the type strings as they
appear in the dictionary (e.g., \code{"S"}, \code{"V"}, \code{"Sx->S"}).
The \code{sentence_prob} parameter is stored as an attribute.
}
\examples{
dic   <- read_dictionary()

# Default usage
prior_probs(dic)

# Applying correction (only 25\% sentences in training data)
prior_probs(dic, sentence_prob = 0.25)
}
\seealso{
\code{\link{sign_grammar}} for per-sign grammatical type frequencies.
}
\keyword{utilities}
