% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{test.cor2}
\alias{test.cor2}
\title{Hypothesis test for a 2-group Pearson or partial correlation difference}
\usage{
test.cor2(cor1, cor2, n1, n2, s)
}
\arguments{
\item{cor1}{estimated correlation for group 1}

\item{cor2}{estimated correlation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}

\item{s}{number of control variables}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of correlation difference
\item z - z test statistic
\item p - two-sided p-value
}
}
\description{
Computes a z test for a difference of population Pearson or partial
correlations in a 2-group design. Set s = 0 for a Pearson correlation.
The hypothesis testing results should be accompanied with a confidence
interval for the difference in population correlation values
(see \link[statpsych]{ci.cor2}).
}
\examples{
test.cor2(.684, .437, 100, 125, 0)

# Should return:
# Estimate      z       p
#    0.247 2.7057 0.00682


}
