% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.lc.mean.bs}
\alias{size.test.lc.mean.bs}
\title{Sample size for a test of a between-subjects mean linear contrast}
\usage{
size.test.lc.mean.bs(alpha, pow, var, es, v)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{var}{planning value of average within-group variance}

\item{es}{planning value of linear contrast of means}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes)
required to test a linear contrast of population means with desired
power in a between-subjects design. Set the variance planning value
to the largest value within a plausible range for a conservatively
large sample size.

For more details, see Section 3.25 of Bonett (2021, Volume 1)
}
\examples{
v <- c(1/4, 1/4, 1/4, 1/4, -1)
size.test.lc.mean.bs(.05, .90, 1, .5, v)

# Should return:
# Sample size per group
#                    53

v <- c(1, -1, -1, 1)
size.test.lc.mean.bs(.05, .90, 27.5, 5, v)

# Should return:
# Sample size per group
#                    47
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
