% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.stdmean2}
\alias{size.ci.stdmean2}
\title{Sample size for a 2-group standardized mean difference confidence interval}
\usage{
size.ci.stdmean2(alpha, d, w, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{d}{planning value of standardized mean difference}

\item{w}{desired confidence interval width}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size per group for each standardizer
}
\description{
Computes the sample size per group required to estimate two types of
population standardized mean differences (unweighted standardizer and single
group standardizer) with desired confidence interval precision in a 2-group
design. Set the standardized mean difference planning value to the largest
value within a plausible range for a conservatively large sample size. Set
R = 1 for equal sample sizes. For unequal sample sizes, this function assumes
approximately equal population variances.

For more details, see Section 2.13 of Bonett (2021, Volume 1)
}
\examples{
size.ci.stdmean2(.05, 1.0, .5, 1)

# Should return:
#                              n1  n2
# Unweighted standardizer:    139 139
# Single group standardizer:  154 154

size.ci.stdmean2(.05, 1.0, .5, 2)

# Should return:
#                              n1  n2
# Unweighted standardizer:    104 208
# Single group standardizer:  116 232
 

}
\references{
\insertRef{Bonett2009}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
