% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.second}
\alias{size.ci.second}
\title{Sample size for a second-stage confidence interval}
\usage{
size.ci.second(n0, w0, w)
}
\arguments{
\item{n0}{first-stage sample size}

\item{w0}{confidence interval width in first-stage sample}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size for the second-stage sample
}
\description{
Computes the second-stage sample size required to obtain desired confidence
interval precision. This function can use either the total sample size for
all groups in the first stage sample or a single group sample size in the
first stage sample. If the total first-stage sample size is given, then the
function computes the total sample size required in the second-stage sample.
If a single group first-stage sample size is given, then the function
computes the single-group sample size required in the second-stage sample.
The second-stage sample is combined with the first-stage sample to obtain
the desired confidence interval width.

For more details, see Section 1.30 of Bonett (2021, Volume 1)
}
\examples{
size.ci.second(25, 4.38, 2.0)

# Should return:
# Second-stage sample size
#                       95
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
