% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.prop.ps}
\alias{size.ci.prop.ps}
\title{Sample size for a paired-sample proportion difference confidence interval}
\usage{
size.ci.prop.ps(alpha, p1, p2, phi, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{p1}{planning value of proportion for measurement 1}

\item{p2}{planning value of proportion for measurement 2}

\item{phi}{planning value of phi correlation}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population proportion
difference with desired confidence interval precision in a paired-samples
design. Set the proportion planning values to .5 for a conservatively large
sample size. Set the phi correlation planning value to the smallest value
within a plausible range for a conservatively large sample size.

For more details, see Section 3.12 of Bonett (2021, Volume 3)
}
\examples{
size.ci.prop.ps(.05, .25, .35, .6, .1)

# Should return:
# Sample size
#         257


}
\references{
\insertRef{Bonett2021}{statpsych}
}
