% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.var.upper}
\alias{ci.var.upper}
\title{Upper confidence limit of a variance}
\usage{
ci.var.upper(alpha, var, n)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence (one-sided)}

\item{var}{estimated variance}

\item{n}{sample size}
}
\value{
Returns an upper limit (UL) variance planning value
}
\description{
Computes an upper confidence limit for a population variance using an
estimated variance from a sample of size n in a prior study. The upper limit
can be used as a variance planning value in sample size functions for
desired power that require a planning value of the population variance.

For more details, see Section 1.31 of Bonett (2021, Volume 1)
}
\examples{
ci.var.upper(.10, 1.45, 100)

# Should return:
#       UL
# 1.762447
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
