% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.ratio.poisson2}
\alias{ci.ratio.poisson2}
\title{Confidence interval for a ratio of Poisson rates in a 2-group design}
\usage{
ci.ratio.poisson2(alpha, f1, f2, t1, t2)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{f1}{number of event occurrences for group 1}

\item{f2}{number of event occurrences for group 2}

\item{t1}{time period for group 1}

\item{t2}{time period for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated ratio of Poisson rates
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of population Poisson rates in a
2-group design. The confidence interval is based on the binomial method
with an Agresti-Coull confidence interval. This function requires the number
of occurrences of a specific event (f) that were observed over a specific
period of time (t) within each group.
}
\details{
The time periods do not need to be integers and can be expressed in any unit
of time such as seconds, hours, or months. The occurances are assumed to be
independent of one another and the unknown occurrence rate is assumed to be
constant over time within each group condition.
}
\examples{
ci.ratio.poisson2(.05, 19, 5, 30, 40.5)

# Should return:
# Estimate       LL       UL
#     5.13 1.939576 13.71481
 

}
\references{
\insertRef{Price2000}{statpsych}
}
