% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop.fpc}
\alias{ci.prop.fpc}
\title{Confidence interval for a proportion with a finite population
correction}
\usage{
ci.prop.fpc(alpha, f, n, N)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{number of participants who have the attribute}

\item{n}{sample size}

\item{N}{population size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion
\item SE - adjusted standard error with fpc
\item LL - lower limit of the confidence interval with fpc
\item UL - upper limit of the confidence interval with fpc
}
}
\description{
Computes an adjusted Wald interval for a population proportion with a
finite population correction (fpc). This confidence interval is useful
when the sample size is not a small fraction of the population size.

For more details, see Section 1.20 of Bonett (2021, Volume 3)
}
\examples{
ci.prop.fpc(.05, 61, 75, 415)

# Should return:
#   Estimate         SE       LL        UL
#  0.7974684 0.04097594 0.717157 0.8777797


}
\references{
\insertRef{Bonett2021}{statpsych}
}
