% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.phi}
\alias{ci.phi}
\title{Confidence interval for a phi correlation}
\usage{
ci.phi(alpha, f00, f01, f10, f11)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of phi correlation
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a Fisher confidence interval for a population phi correlation.
This function requires the frequency counts from a 2 x 2 contingency table
for two dichotomous variables. This measure of association is usually most
appropriate when both dichotomous variables are naturally dichotomous.

For more details, see Section 3.4 of Bonett (2021, Volume 3)
}
\examples{
ci.phi(.05, 229, 28, 96, 24)

# Should return:
#  Estimate     SE    LL    UL
#     0.123 0.0548 0.015 0.229


}
\references{
\insertRef{Bishop1975}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
