% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.kappa}
\alias{ci.kappa}
\title{Confidence interval for two kappa reliability coefficients}
\usage{
ci.kappa(alpha, f00, f01, f10, f11)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of objects rated 0 by both Rater 1 and Rater 2}

\item{f01}{number of objects rated 0 by Rater 1 and 1 by Rater 2}

\item{f10}{number of objects rated 1 by Rater 1 and 0 by Rater 2}

\item{f11}{number of objects rated 1 by both Rater 1 and Rater 2}
}
\value{
Returns a 2-row matrix. The results in row 1 are for the intraclass
kappa. The results in row 2 are for Cohen's kappa. The columns are:
\itemize{
\item Estimate - estimate of interrater reliability
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for the intraclass kappa coefficient and
Cohen's kappa coefficient with two dichotomous ratings. The G-index of
agreement (see ci.agree) is arguably a better measure of agreement.

For more details, see Section 3.5 of Bonett (2021, Volume 3)
}
\examples{
ci.kappa(.05, 31, 12, 4, 58)

# Should return:
#              Estimate     SE    LL    UL
# IC kappa:       0.674 0.0748 0.527 0.821
# Cohen kappa:    0.676 0.0734 0.532 0.820


}
\references{
\insertRef{Fleiss2003}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
