% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.etasqr}
\alias{ci.etasqr}
\title{Confidence interval for eta-squared}
\usage{
ci.etasqr(alpha, etasqr, df1, df2)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{etasqr}{estimated eta-squared}

\item{df1}{degrees of freedom for effect}

\item{df2}{error degrees of freedom}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Eta-squared - eta-squared (from input)
\item adj Eta-squared - bias adjusted eta-squared estimate
\item SE - recovered standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population eta-squared, partial
eta-squared, or generalized eta-squared in a fixed-factor between-subjects
design. An approximate bias adjusted estimate is computed, and an
approximate standard error is recovered from the confidence interval.

For more details, see Section 3.7 of Bonett (2021, Volume 1)
}
\examples{
ci.etasqr(.05, .15, 2, 57)

# Should return:
# Eta-squared  adj Eta-squared       SE      LL      UL
#        0.15           0.1202  0.07414  0.0102  0.3008
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
