% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{run_sensitivity_analysis}
\alias{run_sensitivity_analysis}
\title{Run Sensitivity Analysis}
\usage{
run_sensitivity_analysis(
  correlation_grid = c(0.2, 0.6),
  n_sims_per_setting = 3,
  base_params = list(dist_covariates_x = c("normal", "poisson", "binomial"),
    dist_covariates_y = c("normal", "poisson", "binomial"), dist_y = "poisson",
    x_intercepts = c(4, -1, -1), y_intercepts = c(4, -1, -1), beta0_y = -1, beta_x =
    c(-0.03, 0.1, -0.2), beta_y = c(0.03, -0.1, 0.2)),
  mcmc_params = list(niter = 50000, nburnin = 30000, thin = 10, nchains = 2),
  model_code,
  base_seed = 123,
  output_dir = NULL
)
}
\arguments{
\item{correlation_grid}{Vector of correlation values to test}

\item{n_sims_per_setting}{Number of simulations per correlation setting}

\item{base_params}{List of base simulation parameters}

\item{mcmc_params}{List of MCMC parameters}

\item{model_code}{NIMBLE model code}

\item{base_seed}{Base random seed}

\item{output_dir}{Output directory for results (default: NULL, uses tempdir())}
}
\value{
List with combined results, summary statistics, and output directory
}
\description{
Performs sensitivity analysis across different correlation structures
}
