% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{weight_distribution}
\alias{weight_distribution}
\title{Weight Distribution of a Graph}
\usage{
weight_distribution(g, cumulative = FALSE, ...)
}
\arguments{
\item{g}{the graph (an igraph object)}

\item{cumulative}{\code{TRUE} if cumulative weights are to be used; default
is \code{FALSE}}

\item{...}{additional parameters to be passed to the igraph function
\code{strength}}
}
\value{
A vector with the weighted degree distribution for the graph
\code{g}.
}
\description{
Obtain the weight distribution of a graph, indicating for each strength from
zero to the maximum strength of any vertex, the proportion of vertices with
such a strength. This assumes positive integer weights.
}
\examples{
g=igraph::graph_from_literal(1-2,2-3:4,3-4:5:6,5-1)
igraph::E(g)$weight=c(1,2,1,4,2,1,1)
table(igraph::strength(g))/6
weight_distribution(g)
}
