% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord3D.R
\name{allvectors3D}
\alias{allvectors3D}
\title{Plot Vectors in 3D}
\usage{
allvectors3D(V, th = c(0, 30, 60, 90, 120, 150), V2 = NULL, col = NULL)
}
\arguments{
\item{V}{Either a vector of length 3 or a matrix with each column a vector
of length 3.}

\item{th}{A vector indicating the angles at which the plot should be shown.}

\item{V2}{A matrix or vector of the same dimensions as V indicating the
starting points of the vectors in V (default is the origin for all).}

\item{col}{Vector colors; if entered, must have a value for each vector.}
}
\value{
No return value, called for side effects
}
\description{
Plot one or more vectors in a 3D plot at one or more angles. A plot is
produced for each entry of \code{th}.
}
\examples{
a=c(2,4,8)
b=c(6,0,4)
oldpar <- par(mfrow=c(3,2))
allvectors3D(cbind(a,b,a-b),V2=matrix(c(rep(0,6),b),3))
par(oldpar)
}
