% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_mean_ks_for_multiplicons.R
\name{obtain_mean_ks_for_each_multiplicon}
\alias{obtain_mean_ks_for_each_multiplicon}
\title{Compute the Mean of Ks values for Each Multiplicon}
\usage{
obtain_mean_ks_for_each_multiplicon(
  multiplicon_file,
  anchorpoint_file,
  species1,
  ks_file,
  outfile,
  anchorpointout_file,
  species2 = NULL
)
}
\arguments{
\item{multiplicon_file}{A file containing multiplicon information.}

\item{anchorpoint_file}{A file containing anchorpoints information with columns like geneX, geneY, and other relevant data.}

\item{species1}{The name of the first species.}

\item{ks_file}{A file containing Ks values.}

\item{outfile}{The output file where the results will be saved.}

\item{anchorpointout_file}{The output file for anchorpoint data with Ks values.}

\item{species2}{(Optional) The name of the second species. Specify this parameter and ks_file if working with two species.}
}
\value{
None. The function saves the results to the specified outfile and anchorpointout_file.
}
\description{
This function takes as input a multiplicon file, an anchorpoint file, Ks values, and other relevant information.
It calculates the mean of Ks values for each multiplicon and associates them with the corresponding data.
}
