% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateKsDistribution4wgd_multiple.v2.R
\name{calculateKsDistribution4wgd_multiple}
\alias{calculateKsDistribution4wgd_multiple}
\title{Calculate the Ks Distribution for Multiple Speices}
\usage{
calculateKsDistribution4wgd_multiple(
  files_list,
  binWidth = 0.1,
  maxK = 5,
  plot.mode = "weighted",
  include.outliers = FALSE,
  minK = 0,
  minAlnLen = 0,
  minIdn = 0,
  minCov = 0
)
}
\arguments{
\item{files_list}{A list of file paths containing Ks data.}

\item{binWidth}{The width of Ks bins for the distribution.}

\item{maxK}{The maximum Ks value to consider.}

\item{plot.mode}{The mode for plotting ("weighted", "average", "min", or "pairwise").}

\item{include.outliers}{Whether to include outliers in the calculation.}

\item{minK}{The minimum Ks value to include in the distribution.}

\item{minAlnLen}{The minimum alignment length to include in the distribution.}

\item{minIdn}{The minimum alignment identity to include in the distribution.}

\item{minCov}{The minimum alignment coverage to include in the distribution.}
}
\value{
A list containing two data frames: "bar" for Ks distribution and "density" for density data.
}
\description{
This function takes a list of data files, calculates the Ks distribution, and returns the results.
}
