% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdGMF-class.R
\name{image.sgdgmf}
\alias{image.sgdgmf}
\title{Heatmap of a GMF model}
\usage{
\method{image}{sgdgmf}(
  x,
  ...,
  type = c("data", "response", "link", "scores", "loadings", "deviance", "pearson",
    "working"),
  resid = FALSE,
  symmetric = FALSE,
  transpose = FALSE,
  limits = NULL,
  palette = NULL
)
}
\arguments{
\item{x}{an object of class \code{sgdgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of data/predictions/residuals which should be returned}

\item{resid}{if \code{TRUE}, plots the residual values}

\item{symmetric}{if \code{TRUE}, symmetrizes the color limits}

\item{transpose}{if \code{TRUE}, transposes the matrix before plotting it}

\item{limits}{the color limits which should be used}

\item{palette}{the color-palette which should be used}
}
\value{
A ggplot object showing the selected heatmap.
}
\description{
Plots a heatmap of either the data, the fitted values, or the residual values
of a GMF model allowing for different types of transformations and normalizations.
Moreover, it also permits to plot the latent score and loading matrices.
}
\examples{
\donttest{# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

 # Fit a GMF model
 gmf = sgdgmf.fit(data$Y, ncomp = 3, family = poisson())

# Get the heatmap of a GMF model
image(gmf, type = "data") # original data
image(gmf, type = "response") # fitted values in response scale
image(gmf, type = "scores") # estimated score matrix
image(gmf, type = "loadings") # estimated loading matrix
image(gmf, type = "deviance", resid = TRUE) # deviance residual matrix
}
}
