% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semTools.R
\name{semTools}
\alias{semTools}
\alias{semTools-package}
\title{semTools: Useful Tools for Structural Equation Modeling}
\description{
The \pkg{semTools} package provides many miscellaneous functions that are
useful for statistical analysis involving SEM in R.  Many functions extend
the funtionality of the \pkg{lavaan} package.  Some sets of functions in
\pkg{semTools} correspond to the same theme. We call such a collection of
functions a \emph{suite}. Our suites include:
\itemize{
\item{Model Fit Evaluation:
\code{\link[=moreFitIndices]{moreFitIndices()}},
\code{\link[=nullRMSEA]{nullRMSEA()}},
\code{\link[=singleParamTest]{singleParamTest()}},
\code{\link[=epcEquivFit]{epcEquivFit()}}, and
\code{\link[=chisqSmallN]{chisqSmallN()}}}
\item{Measurement Invariance:
\code{\link[=measEq.syntax]{measEq.syntax()}},
\code{\link[=partialInvariance]{partialInvariance()}},
\code{\link[=partialInvarianceCat]{partialInvarianceCat()}}, and
\code{\link[=permuteMeasEq]{permuteMeasEq()}}}
\item{Power Analysis:
\code{\link[=SSpower]{SSpower()}},
\code{\link[=findRMSEApower]{findRMSEApower()}},
\code{\link[=plotRMSEApower]{plotRMSEApower()}},
\code{\link[=plotRMSEAdist]{plotRMSEAdist()}},
\code{\link[=findRMSEAsamplesize]{findRMSEAsamplesize()}},
\code{\link[=findRMSEApowernested]{findRMSEApowernested()}},
\code{\link[=plotRMSEApowernested]{plotRMSEApowernested()}}, and
\code{\link[=findRMSEAsamplesizenested]{findRMSEAsamplesizenested()}}}
\item{Missing Data Analysis:
\code{\link[=auxiliary]{auxiliary()}},
\code{\link[=twostage]{twostage()}},
\code{\link[=fmi]{fmi()}},
\code{\link[=bsBootMiss]{bsBootMiss()}},
\code{\link[=quark]{quark()}}, and
\code{\link[=combinequark]{combinequark()}}}
\item{Latent Interactions:
\code{\link[=indProd]{indProd()}},
\code{\link[=orthogonalize]{orthogonalize()}},
\code{\link[=probe2WayMC]{probe2WayMC()}},
\code{\link[=probe3WayMC]{probe3WayMC()}},
\code{\link[=probe2WayRC]{probe2WayRC()}},
\code{\link[=probe3WayRC]{probe3WayRC()}}, and
\code{\link[=plotProbe]{plotProbe()}}}
\item{Exploratory Factor Analysis (EFA):
\code{\link[=efa.ekc]{efa.ekc()}}}
\item{Reliability Estimation:
\code{\link[=compRelSEM]{compRelSEM()}} and
\code{\link[=maximalRelia]{maximalRelia()}}
(see also \code{\link[=AVE]{AVE()}})}
\item{Parceling:
\code{\link[=parcelAllocation]{parcelAllocation()}},
\code{\link[=PAVranking]{PAVranking()}}, and
\code{\link[=poolMAlloc]{poolMAlloc()}}}
\item{Non-Normality:
\code{\link[=skew]{skew()}},
\code{\link[=kurtosis]{kurtosis()}},
\code{\link[=mardiaSkew]{mardiaSkew()}},
\code{\link[=mardiaKurtosis]{mardiaKurtosis()}}, and
\code{\link[=mvrnonnorm]{mvrnonnorm()}}}
}
All users of R (or SEM) are invited to submit functions or ideas for
functions by contacting the maintainer, Terrence Jorgensen
(\email{TJorgensen314@gmail.com}). Contributors are encouraged to use
\code{Roxygen} comments to document their contributed code, which is
consistent with the rest of \pkg{semTools}.  Read the vignette from the
\pkg{roxygen2} package for details:
\code{vignette("rd", package = "roxygen2")}
}
