% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb-sim.R
\name{simulate_new}
\alias{simulate_new}
\alias{sdmTMB_simulate}
\title{Simulate from a spatial/spatiotemporal model}
\usage{
simulate_new(
  formula,
  data,
  mesh,
  family = gaussian(link = "identity"),
  time = NULL,
  B = NULL,
  range = NULL,
  rho = NULL,
  sigma_O = NULL,
  sigma_E = NULL,
  sigma_Z = NULL,
  phi = NULL,
  tweedie_p = NULL,
  df = NULL,
  threshold_coefs = NULL,
  fixed_re = list(omega_s = NULL, epsilon_st = NULL, zeta_s = NULL),
  previous_fit = NULL,
  seed = sample.int(1e+06, 1),
  time_varying = NULL,
  time_varying_type = c("rw", "rw0", "ar1"),
  sigma_V = NULL,
  rho_time = NULL,
  ...
)

sdmTMB_simulate(
  formula,
  data,
  mesh,
  family = gaussian(link = "identity"),
  time = NULL,
  B = NULL,
  range = NULL,
  rho = NULL,
  sigma_O = NULL,
  sigma_E = NULL,
  sigma_Z = NULL,
  phi = NULL,
  tweedie_p = NULL,
  df = NULL,
  threshold_coefs = NULL,
  fixed_re = list(omega_s = NULL, epsilon_st = NULL, zeta_s = NULL),
  previous_fit = NULL,
  seed = sample.int(1e+06, 1),
  time_varying = NULL,
  time_varying_type = c("rw", "rw0", "ar1"),
  sigma_V = NULL,
  rho_time = NULL,
  ...
)
}
\arguments{
\item{formula}{A \emph{one-sided} formula describing the fixed-effect structure.
Random intercepts are not (yet) supported. Fixed effects should match
the corresponding \code{B} argument vector of coefficient values.}

\item{data}{A data frame containing the predictors described in \code{formula} and
the time column if \code{time} is specified.}

\item{mesh}{Output from \code{\link[=make_mesh]{make_mesh()}}.}

\item{family}{Family as in \code{\link[=sdmTMB]{sdmTMB()}}. Delta families are not supported.
Instead, simulate the two component models separately and combine.}

\item{time}{The time column name.}

\item{B}{A vector of beta values (fixed-effect coefficient values).}

\item{range}{Parameter that controls the decay of spatial correlation. If a
vector of length 2, \code{share_range} will be set to \code{FALSE} and the spatial
and spatiotemporal ranges will be unique.}

\item{rho}{Spatiotemporal correlation between years; should be between -1 and
1.}

\item{sigma_O}{SD of spatial process (Omega).}

\item{sigma_E}{SD of spatiotemporal process (Epsilon).}

\item{sigma_Z}{SD of spatially varying coefficient field (Zeta).}

\item{phi}{Observation error scale parameter (e.g., SD in Gaussian).}

\item{tweedie_p}{Tweedie p (power) parameter; between 1 and 2.}

\item{df}{Student-t degrees of freedom.}

\item{threshold_coefs}{An optional vector of threshold coefficient values
if the \code{formula} includes \code{breakpt()} or \code{logistic()}. If \code{breakpt()},
these are slope and cut values. If \code{logistic()}, these are the threshold at
which the function is 50\% of the maximum, the threshold at which the
function is 95\% of the maximum, and the maximum. See the model description
vignette for details.}

\item{fixed_re}{A list of optional random effects to fix at specified
(e.g., previously estimated) values. Values of \code{NULL} will result
in the random effects being simulated.}

\item{previous_fit}{(\strong{Deprecated}; please use \code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}}).
An optional previous \code{\link[=sdmTMB]{sdmTMB()}} fit to pull parameter values.
Will be over-ruled by any non-NULL specified parameter arguments.}

\item{seed}{Seed number.}

\item{time_varying}{An optional one-sided formula describing time-varying
covariates passed through to \code{\link[=sdmTMB]{sdmTMB()}} for building a time-varying random
effect design matrix.}

\item{time_varying_type}{Type of temporal process applied to \code{time_varying}.
Must be one of \code{'rw'}, \code{'rw0'}, or \code{'ar1'}.}

\item{sigma_V}{SD(s) of the time-varying process. Provide a single value or a
vector matching the number of time-varying coefficients.}

\item{rho_time}{Autoregressive correlation(s) for time-varying parameters
when \code{time_varying_type = "ar1"}. Values must lie between -1 and 1 and may
be supplied as a single value or a vector the same length as \code{sigma_V}.}

\item{...}{Any other arguments to pass to \code{\link[=sdmTMB]{sdmTMB()}}.}
}
\value{
A data frame where:
\itemize{
\item The 1st column is the time variable (if present).
\item The 2nd and 3rd columns are the spatial coordinates.
\item \code{omega_s} represents the simulated spatial random effects (only if present).
\item \code{zeta_s} represents the simulated spatial varying covariate field (only if present).
\item \code{epsilon_st} represents the simulated spatiotemporal random effects (only if present).
\item \code{eta} is the true value in link space
\item \code{mu} is the true value in inverse link space.
\item \code{observed} represents the simulated process with observation error.
\item The remaining columns are the fixed-effect model matrix.
}
}
\description{
\code{simulate_new()} uses TMB to simulate \emph{new} data given specified parameter
values. \code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}}, on the other hand, takes an \emph{existing} model fit
and simulates new observations and optionally new random effects.
\strong{Note:} \code{sdmTMB_simulate()} is retained as a synonym for backwards
compatibility. We recommend using \code{simulate_new()} going forward as it more
clearly conveys the function's purpose. \code{sdmTMB_simulate()} may
eventually be deprecated.
}
\examples{
set.seed(123)

# make fake predictor(s) (a1) and sampling locations:
predictor_dat <- data.frame(
  X = runif(300), Y = runif(300),
  a1 = rnorm(300), year = rep(1:6, each = 50)
)
mesh <- make_mesh(predictor_dat, xy_cols = c("X", "Y"), cutoff = 0.1)

sim_dat <- simulate_new(
  formula = ~ 1 + a1,
  data = predictor_dat,
  time = "year",
  mesh = mesh,
  family = gaussian(),
  range = 0.5,
  sigma_E = 0.1,
  phi = 0.1,
  sigma_O = 0.2,
  seed = 42,
  B = c(0.2, -0.4) # B0 = intercept, B1 = a1 slope
)
head(sim_dat)

if (require("ggplot2", quietly = TRUE)) {
  ggplot(sim_dat, aes(X, Y, colour = observed)) +
    geom_point() +
    facet_wrap(~year) +
    scale_color_gradient2()
}

# fit to the simulated data:
fit <- sdmTMB(observed ~ a1, data = sim_dat, mesh = mesh, time = "year")
fit
}
\seealso{
\code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}}
}
