% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_marks.R
\name{add_marks}
\alias{add_marks}
\title{Add marks to an scplot object}
\usage{
add_marks(
  object,
  case = 1,
  positions,
  color = "red",
  size = 1,
  shape = 1,
  variable = ".dvar"
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{positions}{Either a vector indicating the points to be highlighted or a
character string with a logical expression (e.g. \code{values < mean(values)})
indicating the points to be highlighted. Alternatively, an object of class
\code{sc_outlier} returned from the \code{\link[scan:outlier]{scan::outlier()}} function can be used
to mark the detected outliers. A list of such vectors or expressions can
also be provided to add marks for multiple cases at once.}

\item{color}{A character string or a number defining the color of an element.}

\item{size}{Text size relative to the base text size.}

\item{shape}{Number. See \code{pch} graphical parameter on \code{par} help page
\code{\link[=par]{par()}}.}

\item{variable}{Name of the dataline variable to apply the style.}
}
\value{
An object of class \code{scplot} (see \code{\link[=scplot]{scplot()}}) with changed element
\code{marks}.
}
\description{
Marks specific points in an scplot object.
}
\details{
Marks are visualized as points on top of the existing plot. Multiple marks
can be added by calling \code{add_marks()} multiple times.

If \code{positions} is an object returned from an outlier analysis via
\code{outlier()}, the corresponding outliers are marked. If \code{positions} is a
list, marks are added for each case in the list.
The \code{variable} argument specifies the variable on which the marks are
applied. By default, the variable \code{.dvar} is used. If multiple cases are
plotted, the \code{case} argument specifies for which case(s) the marks are
added.
}
\examples{
library(scan)
p1 <- scplot(exampleA1B1A2B2$Moritz) |> add_marks(positions = c(1,5,10,14))
p1 <- scplot(Huber2014) |> add_marks(positions = outlier(Huber2014))
}
\author{
Juergen Wilbert
}
